/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.common.redis.lock;

import com.hccake.ballcat.common.redis.lock.Action;
import com.hccake.ballcat.common.redis.lock.CacheLock;
import com.hccake.ballcat.common.redis.lock.StateHandler;
import com.hccake.ballcat.common.redis.lock.function.ExceptionHandler;
import com.hccake.ballcat.common.redis.lock.function.ThrowingExecutor;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.springframework.util.Assert;

public final class DistributedLock<T>
implements Action<T>,
StateHandler<T> {
    T result;
    String key;
    Long timeout;
    TimeUnit timeUnit;
    ThrowingExecutor<T> executeAction;
    UnaryOperator<T> successAction;
    Supplier<T> lockFailAction;
    ExceptionHandler exceptionHandler = DistributedLock::throwException;

    public static <T> Action<T> instance() {
        return new DistributedLock<T>();
    }

    @Override
    public StateHandler<T> action(String lockKey, long timeout, TimeUnit timeUnit, ThrowingExecutor<T> action) {
        Assert.isTrue((this.executeAction == null ? 1 : 0) != 0, (String)"execute action has been already set");
        Assert.notNull(action, (String)"execute action cant be null");
        Assert.hasText((String)lockKey, (String)"lock key cant be blank");
        this.executeAction = action;
        this.key = lockKey;
        this.timeout = timeout;
        this.timeUnit = timeUnit;
        return this;
    }

    @Override
    public StateHandler<T> onSuccess(UnaryOperator<T> action) {
        Assert.isTrue((this.successAction == null ? 1 : 0) != 0, (String)"success action has been already set");
        Assert.notNull(action, (String)"success action cant be null");
        this.successAction = action;
        return this;
    }

    @Override
    public StateHandler<T> onLockFail(Supplier<T> action) {
        Assert.isTrue((this.lockFailAction == null ? 1 : 0) != 0, (String)"lock fail action has been already set");
        Assert.notNull(action, (String)"lock fail action cant be null");
        this.lockFailAction = action;
        return this;
    }

    @Override
    public StateHandler<T> onException(ExceptionHandler exceptionHandler) {
        Assert.notNull((Object)exceptionHandler, (String)"exception handler cant be null");
        this.exceptionHandler = exceptionHandler;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T lock() {
        String requestId = UUID.randomUUID().toString();
        if (Boolean.TRUE.equals(CacheLock.lock(this.key, requestId, this.timeout, this.timeUnit))) {
            Object value = null;
            boolean exResolved = false;
            try {
                value = this.executeAction.execute();
                this.result = value;
            }
            catch (Throwable e) {
                this.exceptionHandler.handle(e);
                exResolved = true;
            }
            finally {
                CacheLock.releaseLock(this.key, requestId);
            }
            if (!exResolved && this.successAction != null) {
                this.result = this.successAction.apply(value);
            }
        } else if (this.lockFailAction != null) {
            this.result = this.lockFailAction.get();
        }
        return this.result;
    }

    private static <E extends Throwable> void throwException(Throwable t) throws E {
        throw t;
    }
}

