/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.common.redis.thread;

import cn.hutool.core.text.CharSequenceUtil;
import com.hccake.ballcat.common.core.thread.AbstractQueueThread;
import com.hccake.ballcat.common.redis.RedisHelper;
import com.hccake.ballcat.common.util.JsonUtils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public abstract class AbstractRedisThread<E>
extends AbstractQueueThread<E> {
    private static final Logger log = LoggerFactory.getLogger(AbstractRedisThread.class);
    @Autowired
    protected RedisHelper redisHelper;
    protected boolean run = true;
    protected final ReentrantLock lock = new ReentrantLock();
    protected final Condition condition = this.lock.newCondition();

    public abstract String getKey();

    protected String convertToString(@NotNull E e) {
        return JsonUtils.toJson(e);
    }

    protected Type getObjType() {
        return ((ParameterizedType)((Object)((Object)this)).getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }

    @Nullable
    protected E convertToObj(String str) {
        if (CharSequenceUtil.isBlank((CharSequence)str)) {
            return null;
        }
        return (E)JsonUtils.toObj((String)str, (Type)this.getObjType());
    }

    public void put(E e) {
        if (e != null) {
            try {
                this.lock.lockInterruptibly();
                try {
                    RedisHelper.rPush(this.getKey(), this.convertToString(e));
                    this.condition.signal();
                }
                finally {
                    this.lock.unlock();
                }
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            catch (Exception ex) {
                log.error("{} put error, param: {}", new Object[]{((Object)((Object)this)).getClass().toString(), e, ex});
            }
        }
    }

    protected String get() {
        return RedisHelper.lPop(this.getKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public E poll(long time) throws InterruptedException {
        if (!this.isRun()) {
            return null;
        }
        this.lock.lockInterruptibly();
        try {
            String pop;
            long nanos = TimeUnit.MILLISECONDS.toNanos(time);
            while (!StringUtils.hasText((String)(pop = this.get()))) {
                nanos = this.condition.awaitNanos(nanos);
                if (this.isRun() && nanos > 0L) continue;
            }
            E e = this.convertToObj(pop);
            return e;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void shutdown(List<E> list) {
        this.run = false;
        for (E e : list) {
            this.put(e);
            log.error("{}", e);
        }
    }

    public boolean isRun() {
        return this.run && !this.isInterrupted();
    }
}

