/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.common.queue;

import java.util.Collection;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class WaitQueue<V> {
    private final LinkedBlockingQueue<V> queue;

    public WaitQueue() {
        this(new LinkedBlockingQueue());
    }

    public WaitQueue(LinkedBlockingQueue<V> queue) {
        this.queue = queue;
    }

    public V get() {
        return this.queue.poll();
    }

    public V poll() throws InterruptedException {
        return this.poll(10L, TimeUnit.HOURS);
    }

    public V poll(long timeout, TimeUnit unit) throws InterruptedException {
        V v;
        while ((v = this.queue.poll(timeout, unit)) == null) {
        }
        return v;
    }

    public void clear() {
        this.queue.clear();
    }

    public void add(V seat) {
        this.queue.add(seat);
    }

    public void addAll(Collection<V> accounts) {
        for (V account : accounts) {
            this.add(account);
        }
    }
}

