/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.common.system;

import com.hccake.ballcat.common.exception.CommandTimeoutException;
import com.hccake.ballcat.common.system.CommandResult;
import com.hccake.ballcat.common.util.FileUtils;
import com.hccake.ballcat.common.util.SystemUtils;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.time.LocalDateTime;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;
import org.springframework.util.StringUtils;

public class Command {
    public static final String NEXT_LINE = SystemUtils.lineSeparator();
    public static final String EXIT_COMMAND = "exit";
    private final Process process;
    private final OutputStream stdIn;
    private final File stdOut;
    private final File stdErr;
    private final String nextLine;
    private final String exit;
    private final Charset charset;
    private final LocalDateTime startTime;

    private Command(String init, String nextLine, String exit, Charset charset) throws IOException {
        if (!StringUtils.hasText((String)init)) {
            throw new IllegalArgumentException("Empty init");
        }
        StringTokenizer st = new StringTokenizer(init);
        String[] cmdArray = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            cmdArray[i] = st.nextToken();
            ++i;
        }
        this.stdOut = FileUtils.createTemp();
        this.stdErr = FileUtils.createTemp();
        ProcessBuilder builder = new ProcessBuilder(cmdArray).redirectError(this.stdErr).redirectOutput(this.stdOut);
        this.process = builder.start();
        this.stdIn = this.process.getOutputStream();
        this.nextLine = nextLine;
        this.exit = exit;
        this.charset = charset;
        this.startTime = LocalDateTime.now();
    }

    public static Command of(String init) throws IOException {
        return Command.of(init, SystemUtils.charset());
    }

    public static Command of(String init, Charset charset) throws IOException {
        return Command.of(init, NEXT_LINE, EXIT_COMMAND, charset);
    }

    public static Command of(String init, String nextLine, String exit, Charset charset) throws IOException {
        return new Command(init, nextLine, exit, charset);
    }

    public Command write(String str) throws IOException {
        this.stdIn.write(str.getBytes(this.charset));
        this.stdIn.flush();
        return this;
    }

    public Command line() throws IOException {
        return this.write(this.nextLine);
    }

    public Command exit() throws IOException {
        this.write(this.exit);
        return this.line();
    }

    public Command exec(String str) throws IOException {
        this.write(str);
        return this.line();
    }

    public CommandResult result() throws InterruptedException {
        this.process.waitFor();
        return CommandResult.of(this.stdOut, this.stdErr, this.startTime, LocalDateTime.now(), this.charset);
    }

    public CommandResult result(long millis) throws InterruptedException, CommandTimeoutException {
        if (this.process.waitFor(millis, TimeUnit.MILLISECONDS)) {
            return this.result();
        }
        this.process.destroyForcibly();
        throw new CommandTimeoutException();
    }

    public void close() {
        this.process.destroy();
    }
}

