/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.common.system;

import com.hccake.ballcat.common.util.StreamUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.LocalDateTime;
import org.springframework.util.StringUtils;

public class CommandResult {
    protected File stdOut;
    protected File stdErr;
    private Charset charset;
    protected LocalDateTime startTime;
    protected LocalDateTime endTime;
    protected String strOutput = null;
    protected String strError = null;

    public static CommandResult of(File stdOut, File stdErr, LocalDateTime startTime, LocalDateTime endTime, Charset charset) {
        CommandResult result = new CommandResult();
        result.stdOut = stdOut;
        result.stdErr = stdErr;
        result.charset = charset;
        result.startTime = startTime;
        result.endTime = endTime;
        return result;
    }

    public File stdOut() {
        return this.stdOut;
    }

    public File stdErr() {
        return this.stdErr;
    }

    public String stdOutStr() throws IOException {
        if (!StringUtils.hasText((String)this.strOutput)) {
            try (FileInputStream output = new FileInputStream(this.stdOut);){
                this.strOutput = StreamUtils.toString(output, 0xA00000, this.charset);
            }
        }
        return this.strOutput;
    }

    public String stdErrStr() throws IOException {
        if (!StringUtils.hasText((String)this.strError)) {
            try (FileInputStream error = new FileInputStream(this.stdErr);){
                this.strError = StreamUtils.toString(error, 0xA00000, this.charset);
            }
        }
        return this.strError;
    }

    public InputStream stdOutStream() throws IOException {
        return Files.newInputStream(this.stdOut.toPath(), new OpenOption[0]);
    }

    public InputStream stdErrStream() throws IOException {
        return Files.newInputStream(this.stdErr.toPath(), new OpenOption[0]);
    }

    public void clean() {
        try {
            Files.delete(this.stdOut.toPath());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Files.delete(this.stdErr.toPath());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public LocalDateTime getStartTime() {
        return this.startTime;
    }

    public LocalDateTime getEndTime() {
        return this.endTime;
    }
}

