/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.common.thread;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class ThreadPool {
    private static final Logger log = LoggerFactory.getLogger(ThreadPool.class);
    protected static final ThreadPool INSTANCE;
    protected static final Integer QUEUE_MAX;
    protected final ThreadPoolExecutor pool;

    public static ThreadPool instance() {
        return INSTANCE;
    }

    public boolean isRunning() {
        return this.getCount() > 0L;
    }

    public long getCount() {
        return this.getPool().getTaskCount();
    }

    public void execute(Runnable runnable) {
        this.execute(null, runnable);
    }

    public void execute(String name, Runnable runnable) {
        this.getPool().execute(() -> {
            Thread thread = Thread.currentThread();
            String oldName = thread.getName();
            if (StringUtils.hasText((String)name)) {
                thread.setName(name);
            }
            try {
                runnable.run();
            }
            catch (Throwable throwable) {
                log.error("\u7ebf\u7a0b\u53d1\u751f\u5f02\u5e38!", throwable);
                if (!(throwable instanceof Exception)) {
                    throw throwable;
                }
            }
            finally {
                thread.setName(oldName);
            }
        });
    }

    private ThreadPool(ThreadPoolExecutor pool) {
        this.pool = pool;
    }

    public ThreadPoolExecutor getPool() {
        return this.pool;
    }

    static {
        QUEUE_MAX = 100;
        INSTANCE = new ThreadPool(new ThreadPoolExecutor(300, 100000, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(QUEUE_MAX), runnable -> new Thread(null, runnable), new ThreadPoolExecutor.CallerRunsPolicy()));
    }
}

