/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.common.util;

import com.hccake.ballcat.common.util.ArrayUtils;

public final class BooleanUtils {
    private static final String[] STR_TRUE = new String[]{"1", "true", "yes", "ok", "y"};
    private static final String[] STR_FALSE = new String[]{"0", "false", "no", "n"};

    public static boolean isTrue(Object obj) {
        if (obj instanceof String) {
            return ArrayUtils.contains(STR_TRUE, obj);
        }
        if (obj instanceof Number) {
            return ((Number)obj).doubleValue() > 0.0;
        }
        if (obj instanceof Boolean) {
            return Boolean.TRUE.equals(obj);
        }
        return false;
    }

    public static boolean isFalse(Object obj) {
        if (obj instanceof String) {
            return ArrayUtils.contains(STR_FALSE, obj);
        }
        if (obj instanceof Number) {
            return ((Number)obj).doubleValue() <= 0.0;
        }
        if (obj instanceof Boolean) {
            return Boolean.FALSE.equals(obj);
        }
        return false;
    }

    private BooleanUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

