/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.common.util;

import cn.hutool.core.util.ClassUtil;
import com.hccake.ballcat.common.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ClassUtils
extends ClassUtil {
    private static final Map<String, Boolean> CACHE = new ConcurrentHashMap<String, Boolean>(8);
    private static final Map<Class<?>, Field[]> CACHE_FIELDS = new ConcurrentHashMap(16);

    public static boolean isPresent(String className, ClassLoader classLoader) {
        if (CACHE.containsKey(className)) {
            return CACHE.get(className);
        }
        try {
            Class.forName(className, true, classLoader);
            CACHE.put(className, true);
            return true;
        }
        catch (Exception ex) {
            CACHE.put(className, false);
            return false;
        }
    }

    public static <T> Set<Class<T>> scan(String basePack, Class<?> cls) throws IOException {
        return ClassUtils.scan(basePack, tClass -> cls == null || cls.isAssignableFrom((Class<?>)tClass), (s, e) -> {});
    }

    public static <T> Set<Class<T>> scan(String basePack, Function<Class<T>, Boolean> filter, BiConsumer<String, Exception> error) throws IOException {
        ArrayList<String> classNames = new ArrayList<String>();
        String clsPath = basePack.replace(".", "/");
        URL url = Thread.currentThread().getContextClassLoader().getResource(clsPath);
        if (url == null) {
            return new HashSet<Class<T>>();
        }
        if ("file".equals(url.getProtocol())) {
            String path = url.getFile();
            for (String file : FileUtils.scanFile(path, true)) {
                if (!file.endsWith(".class")) continue;
                String className = basePack + "." + file.substring(path.length(), file.length() - 6).replace(File.separator, ".");
                classNames.add(className);
            }
        } else {
            URLConnection connection = url.openConnection();
            if (connection instanceof JarURLConnection) {
                JarURLConnection jarURLConnection = (JarURLConnection)connection;
                JarFile jarFile = jarURLConnection.getJarFile();
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    String entryName = entry.getName();
                    if (!entryName.endsWith(".class") || !entryName.startsWith(clsPath)) continue;
                    classNames.add(entryName.substring(0, entryName.length() - 6).replace("/", "."));
                }
            }
        }
        HashSet<Class<T>> classes = new HashSet<Class<T>>();
        for (String className : classNames) {
            try {
                Class<?> aClass = Class.forName(className);
                if (!filter.apply(aClass).booleanValue()) continue;
                classes.add(aClass);
            }
            catch (Exception e) {
                error.accept(className, e);
            }
        }
        return classes;
    }

    public static Map<String, Object> toMap(Object o) {
        return ClassUtils.toMap(o, field -> true, Field::getName, (field, v) -> v);
    }

    public static <T> Map<String, T> toMap(Object o, Function<Field, Boolean> filter, Function<Field, String> toKey, BiFunction<Field, Object, T> toVal) {
        if (o == null) {
            return Collections.emptyMap();
        }
        HashMap<String, T> map = new HashMap<String, T>();
        for (Field field : ClassUtils.fields(o.getClass())) {
            if (!filter.apply(field).booleanValue()) continue;
            Object val = null;
            try {
                val = field.get(o);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            map.put(toKey.apply(field), toVal.apply(field, val));
        }
        return map;
    }

    public static Field[] fields(Class<?> cls) {
        return CACHE_FIELDS.computeIfAbsent(cls, k -> {
            ArrayList<Field> fields = new ArrayList<Field>();
            while (k != null && !k.isAssignableFrom(Object.class)) {
                for (Field field : k.getDeclaredFields()) {
                    field.setAccessible(true);
                    fields.add(field);
                }
                k = k.getSuperclass();
            }
            return fields.toArray(new Field[0]);
        });
    }
}

