/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.common.util;

import com.hccake.ballcat.common.util.StreamUtils;
import com.hccake.ballcat.common.util.SystemUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class FileUtils {
    private static File tempDir = SystemUtils.tmpDirBallcat();

    public static void updateTmpDir(String dirName) {
        tempDir = new File(SystemUtils.tmpDir(), dirName);
    }

    public static File getTemplateFile(String name) throws IOException {
        File file;
        if (!tempDir.exists()) {
            tempDir.mkdirs();
        }
        while (!(file = new File(tempDir, System.currentTimeMillis() + "." + name)).createNewFile()) {
        }
        return file;
    }

    public static InputStream getInputStreamByUrlPath(String path) throws IOException {
        URL url = new URL(path);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setConnectTimeout(5000);
        return conn.getInputStream();
    }

    public static List<String> scanFile(String path, boolean recursive) {
        ArrayList<String> list = new ArrayList<String>();
        File file = new File(path);
        if (!file.exists()) {
            return list;
        }
        if (file.isFile()) {
            list.add(file.getAbsolutePath());
        } else {
            File[] files = file.listFiles();
            if (files == null || files.length < 1) {
                return list;
            }
            for (File childFile : files) {
                if (recursive && childFile.isDirectory()) {
                    list.addAll(FileUtils.scanFile(childFile.getAbsolutePath(), true));
                    continue;
                }
                if (!childFile.isFile()) continue;
                list.add(childFile.getAbsolutePath());
            }
        }
        return list;
    }

    public static void createDir(File dir) throws IOException {
        if (dir.exists()) {
            return;
        }
        if (!dir.mkdirs()) {
            throw new IOException("\u6587\u4ef6\u5939\u521b\u5efa\u5931\u8d25! \u6587\u4ef6\u5939\u8def\u5f84: " + dir.getAbsolutePath());
        }
    }

    public static void createFile(File file) throws IOException {
        if (file.exists()) {
            return;
        }
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            throw new IOException("\u7236\u6587\u4ef6\u521b\u5efa\u5931\u8d25! \u6587\u4ef6\u8def\u5f84: " + file.getAbsolutePath());
        }
        if (!file.createNewFile()) {
            throw new IOException("\u6587\u4ef6\u521b\u5efa\u5931\u8d25! \u6587\u4ef6\u8def\u5f84: " + file.getAbsolutePath());
        }
    }

    public static File createTemp() throws IOException {
        return FileUtils.createTemp("ballcat");
    }

    public static File createTemp(String trait) throws IOException {
        return FileUtils.createTemp(trait, tempDir);
    }

    public static File createTemp(String trait, File dir) throws IOException {
        try {
            FileUtils.createDir(dir);
        }
        catch (IOException e) {
            throw new IOException("\u4e34\u65f6\u6587\u4ef6\u5939\u521b\u5efa\u5931\u8d25! \u6587\u4ef6\u5939\u5730\u5740: " + dir.getAbsolutePath(), e);
        }
        return File.createTempFile(trait, "tmp", dir);
    }

    public static File createTemp(InputStream in) throws IOException {
        File file = FileUtils.createTemp();
        try (FileOutputStream out = new FileOutputStream(file);){
            StreamUtils.write(in, out);
        }
        return file;
    }

    public static Path copy(File source, File target, boolean override, CopyOption ... options) throws IOException {
        ArrayList<CopyOption> list = new ArrayList<CopyOption>();
        if (override) {
            list.add(StandardCopyOption.REPLACE_EXISTING);
        }
        if (options != null && options.length > 0) {
            list.addAll(Arrays.asList(options));
        }
        return Files.copy(source.toPath(), target.toPath(), list.toArray(new CopyOption[0]));
    }

    public static boolean delete(File file) {
        try {
            Files.delete(file.toPath());
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    private FileUtils() {
    }
}

