/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.common.util;

import com.hccake.ballcat.common.util.StreamUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.springframework.util.StringUtils;

public final class ImageUtils {
    private static final List<ImageResolver> RESOLVER_LIST = new ArrayList<ImageResolver>(16);

    public static void registerResolver(ImageResolver resolver, int index) {
        RESOLVER_LIST.add(Math.max(index, 0), resolver);
    }

    public static ImageInfo quickResolveClone(InputStream stream) throws IOException {
        InputStream[] streams = StreamUtils.clone(stream, 2);
        ImageInfo info = new ImageInfo();
        info.setStream(streams[0]);
        stream.close();
        stream = streams[1];
        int r1 = stream.read();
        int r2 = stream.read();
        int r3 = stream.read();
        for (ImageResolver resolver : RESOLVER_LIST) {
            if (!resolver.isSupport(r1, r2, r3)) continue;
            resolver.resolve(info, stream);
            break;
        }
        if (!StringUtils.hasText((String)info.getType())) {
            boolean isTiff;
            int r4 = stream.read();
            boolean bl = isTiff = r1 == 77 && r2 == 77 && r3 == 0 && r4 == 42 || r1 == 73 && r2 == 73 && r3 == 42 && r4 == 0;
            if (isTiff) {
                ImageUtils.tiffResolver(stream, info, r1);
            }
        }
        stream.close();
        if (!StringUtils.hasText((String)info.getType())) {
            info.getStream().close();
            throw new IOException("\u672a\u77e5\u56fe\u7247\u7c7b\u578b");
        }
        return info;
    }

    public static ImageInfo resolveClone(InputStream stream) throws IOException {
        InputStream[] streams = StreamUtils.clone(stream, 2);
        ImageInfo info = new ImageInfo();
        info.setStream(streams[0]);
        stream.close();
        stream = streams[1];
        try {
            ImageInputStream io = ImageIO.createImageInputStream(stream);
            Iterator<ImageReader> readers = ImageIO.getImageReaders(io);
            while (readers.hasNext()) {
                ImageReader reader = readers.next();
                info.setType("image/" + reader.getFormatName().toLowerCase(Locale.ROOT));
                reader.setInput(io);
                info.setWidth(reader.getWidth(0));
                info.setHeight(reader.getHeight(0));
            }
            stream.close();
        }
        catch (Exception e) {
            info.getStream().close();
            throw e;
        }
        if (!StringUtils.hasText((String)info.getType())) {
            info.getStream().close();
            throw new IOException("\u672a\u77e5\u56fe\u7247\u7c7b\u578b");
        }
        return info;
    }

    public static ImageInfo mixResolveClone(InputStream stream) throws IOException {
        InputStream[] streams = StreamUtils.clone(stream, 2);
        try {
            return ImageUtils.quickResolveClone(streams[0]);
        }
        catch (Exception e) {
            return ImageUtils.resolveClone(streams[1]);
        }
    }

    private static void tiffResolver(InputStream stream, ImageInfo info, int r1) throws IOException {
        boolean bigEndian = r1 == 77;
        int ifd = StreamUtils.readInt(stream, 4, bigEndian);
        stream.skip(ifd - 8);
        int entries = StreamUtils.readInt(stream, 2, bigEndian);
        for (int i = 1; i <= entries; ++i) {
            int valOffset;
            int tag = StreamUtils.readInt(stream, 2, bigEndian);
            int fieldType = StreamUtils.readInt(stream, 2, bigEndian);
            if (fieldType == 3 || fieldType == 8) {
                valOffset = StreamUtils.readInt(stream, 2, bigEndian);
                stream.skip(2L);
            } else {
                valOffset = StreamUtils.readInt(stream, 4, bigEndian);
            }
            if (tag == 256) {
                info.setWidth(valOffset);
            } else if (tag == 257) {
                info.setHeight(valOffset);
            }
            if (info.getWidth() == -1L || info.getHeight() == -1L) continue;
            info.setType("image/tiff");
            break;
        }
    }

    private ImageUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        RESOLVER_LIST.add(new ImageResolver(){

            @Override
            public boolean isSupport(int r1, int r2, int r3) {
                return r1 == 71 && r2 == 73 && r3 == 70;
            }

            @Override
            public void resolve(ImageInfo info, InputStream stream) throws IOException {
                stream.skip(3L);
                info.setWidth(StreamUtils.readInt(stream, 2, false));
                info.setHeight(StreamUtils.readInt(stream, 2, false));
                info.setType("image/gif");
            }
        });
        RESOLVER_LIST.add(new ImageResolver(){

            @Override
            public boolean isSupport(int r1, int r2, int r3) {
                return r1 == 255 && r2 == 216 && r3 == 255;
            }

            @Override
            public void resolve(ImageInfo info, InputStream stream) throws IOException {
                int r3;
                do {
                    int marker = stream.read();
                    int len = StreamUtils.readInt(stream, 2, true);
                    if (marker == 192 || marker == 193 || marker == 194) {
                        stream.skip(1L);
                        info.setHeight(StreamUtils.readInt(stream, 2, true));
                        info.setWidth(StreamUtils.readInt(stream, 2, true));
                        info.setType("image/jpeg");
                        break;
                    }
                    stream.skip(len - 2);
                } while ((r3 = stream.read()) == 255);
            }
        });
        RESOLVER_LIST.add(new ImageResolver(){

            @Override
            public boolean isSupport(int r1, int r2, int r3) {
                return r1 == 137 && r2 == 80 && r3 == 78;
            }

            @Override
            public void resolve(ImageInfo info, InputStream stream) throws IOException {
                stream.skip(15L);
                info.setWidth(StreamUtils.readInt(stream, 2, true));
                stream.skip(2L);
                info.setHeight(StreamUtils.readInt(stream, 2, true));
                info.setType("image/png");
            }
        });
        RESOLVER_LIST.add(new ImageResolver(){

            @Override
            public boolean isSupport(int r1, int r2, int r3) {
                return r1 == 66 && r2 == 77;
            }

            @Override
            public void resolve(ImageInfo info, InputStream stream) throws IOException {
                stream.skip(15L);
                info.setWidth(StreamUtils.readInt(stream, 2, false));
                stream.skip(2L);
                info.setHeight(StreamUtils.readInt(stream, 2, false));
                info.setType("image/bmp");
            }
        });
    }

    public static interface ImageResolver {
        public boolean isSupport(int var1, int var2, int var3);

        public void resolve(ImageInfo var1, InputStream var2) throws IOException;
    }

    public static class ImageInfo {
        private InputStream stream;
        private long width;
        private long height;
        private String type;

        private ImageInfo() {
        }

        public InputStream getStream() {
            return this.stream;
        }

        public long getWidth() {
            return this.width;
        }

        public long getHeight() {
            return this.height;
        }

        public String getType() {
            return this.type;
        }

        public void setStream(InputStream stream) {
            this.stream = stream;
        }

        public void setWidth(long width) {
            this.width = width;
        }

        public void setHeight(long height) {
            this.height = height;
        }

        public void setType(String type) {
            this.type = type;
        }
    }
}

