/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.common.util;

import cn.hutool.core.net.NetUtil;
import cn.hutool.core.util.ArrayUtil;
import javax.servlet.http.HttpServletRequest;

public final class IpUtils {
    public static final String NODE_FORWARDED_IP = "Node-Forwarded-IP";

    private IpUtils() {
    }

    public static String getIpAddr(HttpServletRequest request) {
        return IpUtils.getIpAddr(request, NODE_FORWARDED_IP);
    }

    public static String getIpAddr(HttpServletRequest request, String ... otherHeaderNames) {
        String[] headers = new String[]{"X-Real-IP", "X-Forwarded-For", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_CLIENT_IP", "HTTP_X_FORWARDED_FOR"};
        if (ArrayUtil.isNotEmpty((Object[])otherHeaderNames)) {
            headers = (String[])ArrayUtil.addAll((Object[][])new String[][]{headers, otherHeaderNames});
        }
        return IpUtils.getClientIpByHeader(request, headers);
    }

    public static String getClientIpByHeader(HttpServletRequest request, String ... headerNames) {
        String ip;
        for (String header : headerNames) {
            ip = request.getHeader(header);
            if (NetUtil.isUnknown((String)ip)) continue;
            return NetUtil.getMultistageReverseProxyIp((String)ip);
        }
        ip = request.getRemoteAddr();
        return NetUtil.getMultistageReverseProxyIp((String)ip);
    }
}

