/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.common.util;

import com.hccake.ballcat.common.util.ClassUtils;
import com.hccake.ballcat.common.util.json.FastjsonJsonToolAdapter;
import com.hccake.ballcat.common.util.json.GsonJsonToolAdapter;
import com.hccake.ballcat.common.util.json.HuToolJsonToolAdapter;
import com.hccake.ballcat.common.util.json.JacksonJsonToolAdapter;
import com.hccake.ballcat.common.util.json.JsonTool;
import com.hccake.ballcat.common.util.json.TypeReference;
import java.lang.reflect.Type;

public final class JsonUtils {
    private static final String JACKSON_CLASS = "com.fasterxml.jackson.databind.ObjectMapper";
    private static final String GSON_CLASS = "com.google.gson.Gson";
    private static final String HUTOOL_JSON_CLASS = "cn.hutool.json.JSONConfig";
    private static final String HUTOOL_JSON_TYPE_REFERENCE_CLASS = "cn.hutool.core.lang.TypeReference";
    private static final String FAST_JSON_CLASS = "com.alibaba.fastjson.JSON";
    private static JsonTool jsonTool;

    private JsonUtils() {
    }

    public static void switchAdapter(JsonTool jsonTool) {
        JsonUtils.jsonTool = jsonTool;
    }

    public static String toJson(Object obj) {
        return jsonTool.toJson(obj);
    }

    public static <T> T toObj(String json, Class<T> r) {
        return jsonTool.toObj(json, r);
    }

    public static <T> T toObj(String json, final Type t) {
        if (JsonUtils.classIsPresent(HUTOOL_JSON_TYPE_REFERENCE_CLASS) && t instanceof cn.hutool.core.lang.TypeReference) {
            return JsonUtils.toObj(json, new TypeReference<T>(){

                @Override
                public Type getType() {
                    return ((cn.hutool.core.lang.TypeReference)t).getType();
                }
            });
        }
        if (JsonUtils.classIsPresent(FAST_JSON_CLASS) && t instanceof com.alibaba.fastjson.TypeReference) {
            return JsonUtils.toObj(json, new TypeReference<T>(){

                @Override
                public Type getType() {
                    return ((com.alibaba.fastjson.TypeReference)t).getType();
                }
            });
        }
        if (JsonUtils.classIsPresent(JACKSON_CLASS) && t instanceof com.fasterxml.jackson.core.type.TypeReference) {
            return JsonUtils.toObj(json, new TypeReference<T>(){

                @Override
                public Type getType() {
                    return ((com.fasterxml.jackson.core.type.TypeReference)t).getType();
                }
            });
        }
        return jsonTool.toObj(json, t);
    }

    public static <T> T toObj(String json, TypeReference<T> t) {
        return jsonTool.toObj(json, t);
    }

    private static boolean classIsPresent(String className) {
        return ClassUtils.isPresent(className, JsonUtils.class.getClassLoader());
    }

    public static JsonTool getJsonTool() {
        return jsonTool;
    }

    static {
        if (JsonUtils.classIsPresent(JACKSON_CLASS)) {
            jsonTool = new JacksonJsonToolAdapter();
        } else if (JsonUtils.classIsPresent(GSON_CLASS)) {
            jsonTool = new GsonJsonToolAdapter();
        } else if (JsonUtils.classIsPresent(HUTOOL_JSON_CLASS)) {
            jsonTool = new HuToolJsonToolAdapter();
        } else if (JsonUtils.classIsPresent(FAST_JSON_CLASS)) {
            jsonTool = new FastjsonJsonToolAdapter();
        }
    }
}

