/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.common.util;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;

public final class LocalDateTimeUtils {
    public static final ZoneOffset DEFAULT_ZONE_OFFSET = ZoneOffset.of("+8");
    public static final ZoneId DEFAULT_ZONE_ID = DEFAULT_ZONE_OFFSET.normalized();
    public static final String STRING_FORMATTER_YMD_HMS = "yyyy-MM-dd HH:mm:ss";
    public static final DateTimeFormatter FORMATTER_YMD_HMS = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    public static final String STRING_FORMATTER_YMD = "yyyy-MM-dd";
    public static final DateTimeFormatter FORMATTER_YMD = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    public static final String STRING_FORMATTER_HMS = "HH:mm:ss";
    public static final DateTimeFormatter FORMATTER_HMS = DateTimeFormatter.ofPattern("HH:mm:ss");

    public static LocalDateTime parse(String str) {
        return LocalDateTime.parse(str, FORMATTER_YMD_HMS);
    }

    public static LocalDateTime parse(Long timestamp) {
        return LocalDateTimeUtils.parse(timestamp, DEFAULT_ZONE_ID);
    }

    public static LocalDateTime parse(Long timestamp, ZoneId zoneId) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(timestamp), zoneId);
    }

    public static Long toTimestamp(LocalDateTime dateTime) {
        return LocalDateTimeUtils.toTimestamp(dateTime, DEFAULT_ZONE_OFFSET);
    }

    public static Long toTimestamp(LocalDateTime dateTime, ZoneOffset offset) {
        return dateTime.toInstant(offset).toEpochMilli();
    }

    public static String format(LocalDateTime dateTime) {
        return LocalDateTimeUtils.format(dateTime, FORMATTER_YMD_HMS);
    }

    public static String format(LocalDateTime dateTime, String formatter) {
        return LocalDateTimeUtils.format(dateTime, DateTimeFormatter.ofPattern(formatter));
    }

    public static String format(LocalDateTime dateTime, DateTimeFormatter formatter) {
        return formatter.format(dateTime);
    }

    public static LocalDate parseDate(String str) {
        return LocalDate.parse(str, FORMATTER_YMD);
    }

    public static String format(LocalDate date) {
        return LocalDateTimeUtils.format(date, FORMATTER_YMD);
    }

    public static String format(LocalDate date, String formatter) {
        return LocalDateTimeUtils.format(date, DateTimeFormatter.ofPattern(formatter));
    }

    public static String format(LocalDate date, DateTimeFormatter formatter) {
        return formatter.format(date);
    }

    public static LocalTime parseTime(String str) {
        return LocalTime.parse(str, FORMATTER_HMS);
    }

    public static String format(LocalTime time) {
        return LocalDateTimeUtils.format(time, FORMATTER_HMS);
    }

    public static String format(LocalTime time, String formatter) {
        return LocalDateTimeUtils.format(time, DateTimeFormatter.ofPattern(formatter));
    }

    public static String format(LocalTime time, DateTimeFormatter formatter) {
        return formatter.format(time);
    }

    private LocalDateTimeUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

