/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.common.util;

import com.hccake.ballcat.common.charset.GSMCharset;
import java.nio.charset.StandardCharsets;

public final class SmsUtils {
    public static final int SMS_PAYLOAD_BYTE_NUM = 140;
    public static final int MAX_WORLD_NUM_IN_GSM = 160;
    public static final int MAX_WORLD_NUM_IN_UCS2 = 70;
    public static final int UDH_BYTE_NUM = 6;

    private SmsUtils() {
    }

    public static int smsNumber(String smsContent) {
        int wordsNum = GSMCharset.need7bitsNum(smsContent);
        if (wordsNum == 0) {
            return 0;
        }
        if (wordsNum > 0) {
            if (wordsNum <= 160) {
                return 1;
            }
            return wordsNum % 153 == 0 ? wordsNum / 153 : wordsNum / 153 + 1;
        }
        byte[] bytes = smsContent.getBytes(StandardCharsets.UTF_16BE);
        wordsNum = bytes.length / 2;
        if (wordsNum <= 70) {
            return 1;
        }
        return wordsNum % 67 == 0 ? wordsNum / 67 : wordsNum / 67 + 1;
    }
}

