/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.common.util;

import java.lang.reflect.Method;
import java.util.List;
import org.springframework.context.expression.MethodBasedEvaluationContext;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public final class SpelUtils {
    public static final ExpressionParser PARSER = new SpelExpressionParser();
    public static final ParameterNameDiscoverer PARAMETER_NAME_DISCOVERER = new LocalVariableTableParameterNameDiscoverer();

    private SpelUtils() {
    }

    public static String parseValueToString(Object rootObject, Method method, Object[] args, String spelExpression) {
        StandardEvaluationContext context = SpelUtils.getSpelContext(rootObject, method, args);
        return SpelUtils.parseValueToString(context, spelExpression);
    }

    public static StandardEvaluationContext getSpelContext(Object rootObject, Method method, Object[] args) {
        MethodBasedEvaluationContext context = new MethodBasedEvaluationContext(rootObject, method, args, PARAMETER_NAME_DISCOVERER);
        String[] parameterNames = PARAMETER_NAME_DISCOVERER.getParameterNames(method);
        if (parameterNames != null && parameterNames.length > 0) {
            for (int i = 0; i < parameterNames.length; ++i) {
                context.setVariable(parameterNames[i], args[i]);
            }
        }
        return context;
    }

    public static String parseValueToString(StandardEvaluationContext context, String spelExpression) {
        return (String)PARSER.parseExpression(spelExpression).getValue((EvaluationContext)context, String.class);
    }

    public static List<String> parseValueToStringList(StandardEvaluationContext context, String spelExpression) {
        return (List)PARSER.parseExpression(spelExpression).getValue((EvaluationContext)context, List.class);
    }
}

