/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.common.util;

import com.hccake.ballcat.common.util.FileUtils;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;

public class StreamUtils {
    public static final int DEFAULT_SIZE = 0xA00000;

    public static byte[] read(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StreamUtils.write(in, out);
        try {
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        finally {
            StreamUtils.close(out);
        }
    }

    public static void write(InputStream in, OutputStream out) throws IOException {
        StreamUtils.write(in, out, 0xA00000);
    }

    public static void write(InputStream in, OutputStream out, int size) throws IOException {
        int len;
        byte[] bytes = new byte[size];
        while ((len = in.read(bytes)) > 0) {
            out.write(bytes, 0, len);
        }
    }

    public static String toString(InputStream in) throws IOException {
        return StreamUtils.toString(in, 0xA00000, StandardCharsets.UTF_8);
    }

    public static String toString(InputStream in, int size, Charset charset) throws IOException {
        int len;
        byte[] bytes = new byte[size];
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        while ((len = in.read(bytes)) > 0) {
            outputStream.write(bytes, 0, len);
        }
        return outputStream.toString(charset.name());
    }

    public static int readInt(InputStream is, int noOfBytes, boolean bigEndian) throws IOException {
        int ret = 0;
        int sv = bigEndian ? (noOfBytes - 1) * 8 : 0;
        int cnt = bigEndian ? -8 : 8;
        for (int i = 0; i < noOfBytes; ++i) {
            ret |= is.read() << sv;
            sv += cnt;
        }
        return ret;
    }

    public static void close(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static InputStream[] clone(InputStream stream, Integer amounts) throws IOException {
        return StreamUtils.clone(stream, amounts, 0xA00000);
    }

    public static InputStream[] clone(InputStream stream, Integer amounts, int size) throws IOException {
        int i;
        int len;
        InputStream[] streams = new InputStream[amounts.intValue()];
        File[] files = new File[amounts.intValue()];
        FileOutputStream[] outs = new FileOutputStream[amounts.intValue()];
        byte[] buffer = new byte[size < 1 ? 0xA00000 : size];
        while ((len = stream.read(buffer)) > -1) {
            int outsLength = outs.length;
            for (i = 0; i < outsLength; ++i) {
                FileOutputStream out = outs[i];
                if (out == null) {
                    files[i] = FileUtils.createTemp("clone." + i + "." + System.currentTimeMillis());
                    outs[i] = out = new FileOutputStream(files[i]);
                }
                out.write(buffer, 0, len);
            }
        }
        for (i = 0; i < files.length; ++i) {
            try {
                outs[i].close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            streams[i] = Files.newInputStream(files[i].toPath(), new OpenOption[0]);
        }
        return streams;
    }

    private StreamUtils() {
    }
}

