/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.common.util;

import java.io.File;
import java.nio.charset.Charset;

public final class SystemUtils {
    public static boolean isWindows() {
        return SystemUtils.osName().contains("Windows");
    }

    public static boolean isLinux() {
        return SystemUtils.osName().contains("Linux");
    }

    public static boolean isMacX() {
        return SystemUtils.osName().contains("OS X");
    }

    public static boolean isMac() {
        return SystemUtils.osName().contains("Mac OS");
    }

    public static boolean isAix() {
        return SystemUtils.osName().contains("AIX");
    }

    public static String osName() {
        return System.getProperty("os.name");
    }

    public static Charset charset() {
        return Charset.forName(System.getProperty("sun.jnu.encoding"));
    }

    public static String lineSeparator() {
        return System.lineSeparator();
    }

    public static String fileSeparator() {
        return File.separator;
    }

    @Deprecated
    public static File tempDir() {
        return SystemUtils.tmpDir();
    }

    public static File tmpDir() {
        return new File(System.getProperty("java.io.tmpdir"));
    }

    public static File tmpDirBallcat() {
        return new File(System.getProperty("java.io.tmpdir"), "ballcat");
    }

    public static File homeDir() {
        return new File(System.getProperty("user.home"));
    }

    public static File homeDirBallcat() {
        return new File(System.getProperty("user.home"), ".ballcat");
    }

    public static File workDir() {
        return new File(System.getProperty("user.dir"));
    }

    public static String username() {
        return System.getProperty("user.name");
    }

    private SystemUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

