/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.common.util.json;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.hccake.ballcat.common.util.json.JsonTool;
import com.hccake.ballcat.common.util.json.TypeReference;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;

public class FastjsonJsonToolAdapter
implements JsonTool {
    static final List<Feature> FEATURES = new ArrayList<Feature>(Feature.values().length);
    static final List<SerializerFeature> SERIALIZER_FEATURES = new ArrayList<SerializerFeature>(SerializerFeature.values().length);
    private static Feature[] features = new Feature[0];
    private static SerializerFeature[] serializerFeatures = new SerializerFeature[0];

    public void config(BiConsumer<List<Feature>, List<SerializerFeature>> consumer) {
        consumer.accept(FEATURES, SERIALIZER_FEATURES);
        features = FEATURES.toArray(new Feature[0]);
        serializerFeatures = SERIALIZER_FEATURES.toArray(new SerializerFeature[0]);
    }

    @Override
    public String toJson(Object obj) {
        return JSON.toJSONString((Object)obj, (SerializerFeature[])serializerFeatures);
    }

    @Override
    public <T> T toObj(String json, Class<T> r) {
        return (T)JSON.parseObject((String)json, r, (Feature[])features);
    }

    @Override
    public <T> T toObj(String json, Type t) {
        return (T)JSON.parseObject((String)json, (Type)t, (Feature[])features);
    }

    @Override
    public <T> T toObj(String json, TypeReference<T> t) {
        return this.toObj(json, t.getType());
    }
}

