/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.common.util.json;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.hccake.ballcat.common.util.json.JsonTool;
import com.hccake.ballcat.common.util.json.TypeReference;
import java.lang.reflect.Type;
import java.util.function.Consumer;

public class JacksonJsonToolAdapter
implements JsonTool {
    static ObjectMapper mapper = new ObjectMapper();

    public void config(Consumer<ObjectMapper> consumer) {
        consumer.accept(mapper);
    }

    @Override
    public String toJson(Object obj) {
        return mapper.writeValueAsString(obj);
    }

    @Override
    public <T> T toObj(String json, Class<T> r) {
        return (T)mapper.readValue(json, r);
    }

    @Override
    public <T> T toObj(String json, Type t) {
        return (T)mapper.readValue(json, mapper.constructType(t));
    }

    @Override
    public <T> T toObj(String json, final TypeReference<T> t) {
        return (T)mapper.readValue(json, new com.fasterxml.jackson.core.type.TypeReference<T>(){

            public Type getType() {
                return t.getType();
            }
        });
    }

    public static ObjectMapper getMapper() {
        return mapper;
    }

    public static void setMapper(ObjectMapper mapper) {
        JacksonJsonToolAdapter.mapper = mapper;
    }

    static {
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }
}

