/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.common.util.tree;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import com.hccake.ballcat.common.util.tree.TreeNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class TreeUtils {
    public static <T extends TreeNode<I>, I> List<T> buildTree(List<T> nodes, I rootId) {
        return TreeUtils.buildTree(nodes, rootId, Function.identity(), null);
    }

    public static <T extends TreeNode<I>, I> List<T> buildTree(List<T> nodes, I rootId, Comparator<? super T> comparator) {
        return TreeUtils.buildTree(nodes, rootId, Function.identity(), comparator);
    }

    public static <T extends TreeNode<I>, I, R> List<T> buildTree(List<R> list, I rootId, Function<R, T> convertToTree) {
        return TreeUtils.buildTree(list, rootId, convertToTree, null);
    }

    public static <T extends TreeNode<I>, I, R> List<T> buildTree(List<R> list, I rootId, Function<R, T> convertToTree, Comparator<? super T> comparator) {
        if (list == null || list.isEmpty()) {
            return new ArrayList();
        }
        Stream<Object> tStream = list.stream().map(convertToTree);
        if (comparator != null) {
            tStream = tStream.sorted(comparator);
        }
        Map childrenMap = tStream.collect(Collectors.groupingBy(TreeNode::getParentKey, LinkedHashMap::new, Collectors.toList()));
        List treeList = (List)childrenMap.get(rootId);
        Assert.notEmpty((Iterable)treeList, (String)"\u9519\u8bef\u7684\u6570\u636e\uff0c\u627e\u4e0d\u5230\u6839\u8282\u70b9\u7684\u5b50\u8282\u70b9", (Object[])new Object[0]);
        treeList.forEach(node -> TreeUtils.setChildren(node, childrenMap));
        return treeList;
    }

    public static <T extends TreeNode<I>, I> void setChildren(T parent, Map<I, List<T>> childrenMap) {
        I parentId = parent.getKey();
        List<TreeNode> children = childrenMap.get(parentId);
        if (CollUtil.isNotEmpty(children)) {
            parent.setChildren(children);
            children.forEach(node -> TreeUtils.setChildren(node, childrenMap));
        } else {
            parent.setChildren(new ArrayList());
        }
    }

    public static <T extends TreeNode<I>, I> List<T> getLeafs(T parent) {
        ArrayList leafs = new ArrayList();
        TreeUtils.fillLeaf(parent, leafs);
        return leafs;
    }

    public static <T extends TreeNode<I>, I> void fillLeaf(T parent, List<T> leafs) {
        List children = parent.getChildren();
        if (CollUtil.isEmpty(children)) {
            leafs.add(parent);
            return;
        }
        for (TreeNode child : children) {
            TreeUtils.fillLeaf(child, leafs);
        }
    }

    public static <T extends TreeNode<I>, I> List<I> getTreeNodeIds(List<T> treeList) {
        ArrayList ids = new ArrayList();
        TreeUtils.fillTreeNodeIds(ids, treeList);
        return ids;
    }

    public static <T extends TreeNode<I>, I> void fillTreeNodeIds(List<I> ids, List<T> treeList) {
        if (CollUtil.isEmpty(treeList)) {
            return;
        }
        for (TreeNode treeNode : treeList) {
            ids.add(treeNode.getKey());
            List children = treeNode.getChildren();
            if (!CollUtil.isNotEmpty(children)) continue;
            TreeUtils.fillTreeNodeIds(ids, children);
        }
    }

    public static <T extends TreeNode<I>, I> List<T> treeToList(T treeNode) {
        return TreeUtils.treeToList(treeNode, Function.identity());
    }

    public static <T extends TreeNode<I>, I, R> List<R> treeToList(T treeNode, Function<T, R> converter) {
        ArrayList<R> list = new ArrayList<R>();
        LinkedList queue = new LinkedList();
        queue.add(treeNode);
        while (!queue.isEmpty()) {
            TreeNode node = (TreeNode)queue.poll();
            if (node == null) continue;
            List children = node.getChildren();
            if (CollUtil.isNotEmpty(children)) {
                queue.addAll(children);
            }
            node.setChildren(null);
            list.add(converter.apply(node));
        }
        return list;
    }

    public static <T extends TreeNode<I>, I> List<T> treeToList(List<T> treeNodes) {
        return TreeUtils.treeToList(treeNodes, Function.identity());
    }

    public static <T extends TreeNode<I>, I, R> List<R> treeToList(List<T> treeNodes, Function<T, R> converter) {
        return treeNodes.stream().map(node -> TreeUtils.treeToList(node, converter)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public static <T extends TreeNode<I>, I> List<T> pruneTree(List<T> treeNodes, Predicate<T> matcher) {
        ArrayList<TreeNode> result = new ArrayList<TreeNode>();
        if (CollUtil.isEmpty(treeNodes)) {
            return result;
        }
        for (TreeNode treeNode : treeNodes) {
            List children = TreeUtils.pruneTree(treeNode.getChildren(), matcher);
            if (CollUtil.isNotEmpty(children)) {
                treeNode.setChildren(children);
                result.add(treeNode);
                continue;
            }
            if (!matcher.test(treeNode)) continue;
            treeNode.setChildren(null);
            result.add(treeNode);
        }
        return result;
    }

    public static <T extends TreeNode<I>, I> T pruneTree(T treeNode, Predicate<T> matcher) {
        boolean nodeMatched;
        List children = TreeUtils.pruneTree(treeNode.getChildren(), matcher);
        boolean childrenMatched = CollUtil.isNotEmpty(children);
        if (childrenMatched) {
            treeNode.setChildren(children);
        }
        return (T)((nodeMatched = matcher.test(treeNode)) || childrenMatched ? treeNode : null);
    }

    public static <T extends TreeNode<I>, I> void forEachDFS(T treeNode, T parentTreeNode, BiConsumer<T, T> action) {
        action.accept(treeNode, parentTreeNode);
        List children = treeNode.getChildren();
        TreeUtils.forEachDFS(children, parentTreeNode, action);
    }

    public static <T extends TreeNode<I>, I> void forEachDFS(List<T> treeNodes, T parentTreeNode, BiConsumer<T, T> action) {
        if (treeNodes == null || treeNodes.isEmpty()) {
            return;
        }
        for (TreeNode treeNode : treeNodes) {
            List children = treeNode.getChildren();
            action.accept(treeNode, parentTreeNode);
            TreeUtils.forEachDFS(children, treeNode, action);
        }
    }

    private TreeUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

