/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.common.websocket;

import com.hccake.ballcat.common.util.JsonUtils;
import com.hccake.ballcat.common.websocket.message.JsonWebSocketMessage;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;

public final class WebSocketMessageSender {
    private static final Logger log = LoggerFactory.getLogger(WebSocketMessageSender.class);

    private WebSocketMessageSender() {
    }

    public static void send(WebSocketSession session, JsonWebSocketMessage message) {
        WebSocketMessageSender.send(session, JsonUtils.toJson((Object)message));
    }

    public static boolean send(WebSocketSession session, String message) {
        if (session == null) {
            log.error("[send] session \u4e3a null");
            return false;
        }
        if (!session.isOpen()) {
            log.error("[send] session \u5df2\u7ecf\u5173\u95ed");
            return false;
        }
        try {
            session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)message));
        }
        catch (IOException e) {
            log.error("[send] session({}) \u53d1\u9001\u6d88\u606f({}) \u5f02\u5e38", new Object[]{session, message, e});
            return false;
        }
        return true;
    }
}

