/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.common.websocket.distribute;

import cn.hutool.core.collection.CollUtil;
import com.hccake.ballcat.common.websocket.WebSocketMessageSender;
import com.hccake.ballcat.common.websocket.distribute.MessageDO;
import com.hccake.ballcat.common.websocket.distribute.MessageDistributor;
import com.hccake.ballcat.common.websocket.session.WebSocketSessionStore;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.socket.WebSocketSession;

public abstract class AbstractMessageDistributor
implements MessageDistributor {
    private static final Logger log = LoggerFactory.getLogger(AbstractMessageDistributor.class);
    private final WebSocketSessionStore webSocketSessionStore;

    protected AbstractMessageDistributor(WebSocketSessionStore webSocketSessionStore) {
        this.webSocketSessionStore = webSocketSessionStore;
    }

    protected void doSend(MessageDO messageDO) {
        Boolean needBroadcast = messageDO.getNeedBroadcast();
        Collection<Object> sessionKeys = needBroadcast != null && needBroadcast != false ? this.webSocketSessionStore.getSessionKeys() : messageDO.getSessionKeys();
        if (CollUtil.isEmpty(sessionKeys)) {
            log.warn("\u53d1\u9001 websocket \u6d88\u606f\uff0c\u5374\u6ca1\u6709\u627e\u5230\u5bf9\u5e94 sessionKeys, messageDo: {}", (Object)messageDO);
            return;
        }
        String messageText = messageDO.getMessageText();
        Boolean onlyOneClientInSameKey = messageDO.getOnlyOneClientInSameKey();
        for (Object sessionKey : sessionKeys) {
            Collection<WebSocketSession> sessions = this.webSocketSessionStore.getSessions(sessionKey);
            if (!CollUtil.isNotEmpty(sessions)) continue;
            if (onlyOneClientInSameKey != null && onlyOneClientInSameKey.booleanValue()) {
                WebSocketSession wsSession = (WebSocketSession)CollUtil.get(sessions, (int)0);
                WebSocketMessageSender.send(wsSession, messageText);
                continue;
            }
            for (WebSocketSession wsSession : sessions) {
                WebSocketMessageSender.send(wsSession, messageText);
            }
        }
    }
}

