/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.common.websocket.distribute;

import com.hccake.ballcat.common.util.JsonUtils;
import com.hccake.ballcat.common.websocket.distribute.AbstractMessageDistributor;
import com.hccake.ballcat.common.websocket.distribute.MessageDO;
import com.hccake.ballcat.common.websocket.exception.ErrorJsonMessageException;
import com.hccake.ballcat.common.websocket.session.WebSocketSessionStore;
import java.nio.charset.StandardCharsets;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.spring.annotation.MessageModel;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.apache.rocketmq.spring.core.RocketMQListener;
import org.apache.rocketmq.spring.core.RocketMQTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

@RocketMQMessageListener(consumerGroup="${spring.application.name:default-ballcat-application}-${spring.profiles.active:dev}", topic="${spring.application.name:default-ballcat-application}-${spring.profiles.active:dev}", selectorExpression="${ballcat.websocket.mq.tag}", messageModel=MessageModel.BROADCASTING)
public class RocketmqMessageDistributor
extends AbstractMessageDistributor
implements RocketMQListener<MessageExt> {
    private static final Logger log = LoggerFactory.getLogger(RocketmqMessageDistributor.class);
    @Value(value="${spring.application.name}")
    private String appName;
    @Value(value="${ballcat.websocket.mq.tag}")
    private String tag;
    private final RocketMQTemplate template;

    public RocketmqMessageDistributor(WebSocketSessionStore webSocketSessionStore, RocketMQTemplate template) {
        super(webSocketSessionStore);
        this.template = template;
    }

    @Override
    public void distribute(MessageDO messageDO) {
        log.info("the send message body is [{}]", (Object)messageDO);
        String destination = this.appName + ":" + this.tag;
        SendResult sendResult = (SendResult)this.template.sendAndReceive(destination, (Object)JsonUtils.toJson((Object)messageDO), SendResult.class);
        if (log.isDebugEnabled()) {
            log.debug("send message to `{}` finished. result:{}", (Object)destination, (Object)sendResult);
        }
    }

    public void onMessage(MessageExt message) {
        String body = new String(message.getBody(), StandardCharsets.UTF_8);
        MessageDO event = (MessageDO)JsonUtils.toObj((String)body, MessageDO.class);
        log.info("the content is [{}]", (Object)event);
        try {
            this.doSend(event);
        }
        catch (Exception e) {
            log.error("MQ\u6d88\u8d39\u4fe1\u606f\u5904\u7406\u5f02\u5e38: {}", (Object)e.getMessage(), (Object)e);
            throw new ErrorJsonMessageException("MQ\u6d88\u8d39\u4fe1\u606f\u5904\u7406\u5f02\u5e38, " + e.getMessage());
        }
    }
}

