/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.log.handler;

import cn.hutool.core.util.URLUtil;
import com.hccake.ballcat.common.desensitize.DesensitizationHandlerHolder;
import com.hccake.ballcat.common.desensitize.enums.RegexDesensitizationTypeEnum;
import com.hccake.ballcat.common.log.access.handler.AccessLogHandler;
import com.hccake.ballcat.common.log.util.LogUtils;
import com.hccake.ballcat.common.security.util.SecurityUtils;
import com.hccake.ballcat.common.util.IpUtils;
import com.hccake.ballcat.common.util.JsonUtils;
import com.hccake.ballcat.log.model.entity.AccessLog;
import com.hccake.ballcat.log.thread.AccessLogSaveThread;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.web.servlet.HandlerMapping;

public class CustomAccessLogHandler
implements AccessLogHandler<AccessLog> {
    private static final Logger log = LoggerFactory.getLogger(CustomAccessLogHandler.class);
    private static final String APPLICATION_JSON = "application/json";
    private final AccessLogSaveThread accessLogSaveThread;
    private final List<String> needDesensitizeParams = Arrays.asList("password", "pass", "passConfirm");

    public CustomAccessLogHandler(AccessLogSaveThread accessLogSaveThread) {
        if (!accessLogSaveThread.isAlive()) {
            accessLogSaveThread.start();
        }
        this.accessLogSaveThread = accessLogSaveThread;
    }

    public AccessLog buildLog(HttpServletRequest request, HttpServletResponse response, Long time, Throwable myThrowable) {
        Object matchingPatternAttr = request.getAttribute(HandlerMapping.BEST_MATCHING_PATTERN_ATTRIBUTE);
        String matchingPattern = matchingPatternAttr == null ? "" : String.valueOf(matchingPatternAttr);
        String uri = URLUtil.getPath((String)request.getRequestURI());
        AccessLog accessLog = new AccessLog().setTraceId(MDC.get((String)"traceId")).setCreateTime(LocalDateTime.now()).setTime(time).setIp(IpUtils.getIpAddr((HttpServletRequest)request)).setMethod(request.getMethod()).setUserAgent(request.getHeader("user-agent")).setUri(uri).setMatchingPattern(matchingPattern).setErrorMsg(Optional.ofNullable(myThrowable).map(Throwable::getMessage).orElse("")).setHttpStatus(Integer.valueOf(response.getStatus()));
        String params = this.getParams(request);
        accessLog.setReqParams(params);
        if (this.shouldRecordRequestBody(request, uri)) {
            accessLog.setReqBody(LogUtils.getRequestBody((HttpServletRequest)request));
        }
        if (this.shouldRecordResponseBody(response, uri)) {
            accessLog.setResult(LogUtils.getResponseBody((HttpServletRequest)request, (HttpServletResponse)response));
        }
        Optional.ofNullable(SecurityUtils.getUser()).ifPresent(x -> {
            accessLog.setUserId(x.getUserId());
            accessLog.setUsername(x.getUsername());
        });
        return accessLog;
    }

    protected boolean shouldRecordRequestBody(HttpServletRequest request, String uri) {
        return !LogUtils.isMultipartContent((HttpServletRequest)request) && !uri.matches("^/system/user/pass/[^/]+/?$") && !uri.matches("^/captcha/.*$");
    }

    protected boolean shouldRecordResponseBody(HttpServletResponse response, String uri) {
        return !uri.endsWith("/page") && response.getContentType() != null && response.getContentType().contains(APPLICATION_JSON);
    }

    public String getParams(HttpServletRequest request) {
        String params;
        try {
            HashMap<String, String[]> parameterMap = new HashMap<String, String[]>(request.getParameterMap());
            for (String paramKey : this.needDesensitizeParams) {
                String[] values = (String[])parameterMap.get(paramKey);
                if (values == null || values.length == 0) continue;
                String value = DesensitizationHandlerHolder.getRegexDesensitizationHandler().handle(values[0], RegexDesensitizationTypeEnum.ENCRYPTED_PASSWORD);
                parameterMap.put(paramKey, new String[]{value});
            }
            params = JsonUtils.toJson(parameterMap);
        }
        catch (Exception e) {
            params = "\u8bb0\u5f55\u53c2\u6570\u5f02\u5e38";
            log.error("[prodLog]\uff0c\u53c2\u6570\u83b7\u53d6\u5e8f\u5217\u5316\u5f02\u5e38", (Throwable)e);
        }
        return params;
    }

    public void saveLog(AccessLog accessLog) {
        this.accessLogSaveThread.put(accessLog);
    }
}

