/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.notify.handler.impl;

import com.hccake.ballcat.notify.handler.AbstractNotifyInfoHandler;
import com.hccake.ballcat.notify.handler.impl.AnnouncementPushMessage;
import com.hccake.ballcat.notify.model.domain.AnnouncementNotifyInfo;
import com.hccake.ballcat.notify.model.entity.UserAnnouncement;
import com.hccake.ballcat.notify.service.UserAnnouncementService;
import com.hccake.ballcat.system.model.entity.SysUser;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class AnnouncementNotifyInfoHandler
extends AbstractNotifyInfoHandler<AnnouncementNotifyInfo, AnnouncementPushMessage> {
    private final UserAnnouncementService userAnnouncementService;

    @Override
    protected void persistMessage(List<SysUser> userList, AnnouncementNotifyInfo announcementNotifyInfo) {
        ArrayList<UserAnnouncement> userAnnouncements = new ArrayList<UserAnnouncement>(userList.size());
        for (SysUser sysUser : userList) {
            Long userId = sysUser.getUserId();
            UserAnnouncement userAnnouncement = this.userAnnouncementService.prodUserAnnouncement(userId, announcementNotifyInfo.getId());
            userAnnouncements.add(userAnnouncement);
        }
        this.userAnnouncementService.saveBatch(userAnnouncements);
    }

    @Override
    protected AnnouncementPushMessage createMessage(AnnouncementNotifyInfo announcementNotifyInfo) {
        AnnouncementPushMessage message = new AnnouncementPushMessage();
        message.setId(announcementNotifyInfo.getId());
        message.setTitle(announcementNotifyInfo.getTitle());
        message.setContent(announcementNotifyInfo.getContent());
        message.setImmortal(announcementNotifyInfo.getImmortal());
        message.setDeadline(announcementNotifyInfo.getDeadline());
        return message;
    }

    public AnnouncementNotifyInfoHandler(UserAnnouncementService userAnnouncementService) {
        this.userAnnouncementService = userAnnouncementService;
    }
}

