/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.notify.recipient;

import com.hccake.ballcat.notify.recipient.RecipientFilter;
import com.hccake.ballcat.system.model.entity.SysUser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RecipientHandler {
    private static final Logger log = LoggerFactory.getLogger(RecipientHandler.class);
    private final Map<Integer, RecipientFilter> recipientFilterMap = new LinkedHashMap<Integer, RecipientFilter>();

    public RecipientHandler(List<RecipientFilter> recipientFilterList) {
        for (RecipientFilter recipientFilter : recipientFilterList) {
            this.recipientFilterMap.put(recipientFilter.filterType(), recipientFilter);
        }
    }

    public List<SysUser> query(Integer filterType, List<Object> filterCondition) {
        RecipientFilter recipientFilter = this.recipientFilterMap.get(filterType);
        if (recipientFilter == null) {
            log.error("Unknown recipient filter\uff1a[{}]\uff0cfilterCondition\uff1a{}", (Object)filterType, filterCondition);
            return new ArrayList<SysUser>();
        }
        return recipientFilter.filter(filterCondition);
    }

    public boolean match(Integer recipientFilterType, Object filterAttr, List<Object> recipientFilterCondition) {
        RecipientFilter recipientFilter = this.recipientFilterMap.get(recipientFilterType);
        return recipientFilter != null && recipientFilter.match(filterAttr, recipientFilterCondition);
    }

    public Map<Integer, Object> getFilterAttrs(SysUser sysUser) {
        HashMap<Integer, Object> map = new HashMap<Integer, Object>(this.recipientFilterMap.size());
        for (RecipientFilter recipientFilter : this.recipientFilterMap.values()) {
            Object obj = recipientFilter.getFilterAttr(sysUser);
            map.put(recipientFilter.filterType(), obj);
        }
        return map;
    }
}

