/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.notify.recipient;

import com.hccake.ballcat.notify.enums.NotifyRecipientFilterTypeEnum;
import com.hccake.ballcat.notify.recipient.RecipientFilter;
import com.hccake.ballcat.system.model.entity.SysUser;
import com.hccake.ballcat.system.service.SysUserService;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class SpecifyOrganizationRecipientFilter
implements RecipientFilter {
    private final SysUserService sysUserService;

    @Override
    public Integer filterType() {
        return NotifyRecipientFilterTypeEnum.SPECIFY_ORGANIZATION.getValue();
    }

    @Override
    public List<SysUser> filter(List<Object> filterCondition) {
        List organizationIds = filterCondition.stream().map(Long.class::cast).collect(Collectors.toList());
        return this.sysUserService.listByOrganizationIds(organizationIds);
    }

    @Override
    public Object getFilterAttr(SysUser sysUser) {
        return sysUser.getOrganizationId();
    }

    @Override
    public boolean match(Object filterAttr, List<Object> filterCondition) {
        Integer organizationId = (Integer)filterAttr;
        return filterCondition.stream().map(Integer.class::cast).anyMatch(x -> x.equals(organizationId));
    }

    public SpecifyOrganizationRecipientFilter(SysUserService sysUserService) {
        this.sysUserService = sysUserService;
    }
}

