/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.notify.service.impl;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.IdUtil;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import com.hccake.ballcat.common.core.constant.enums.BooleanEnum;
import com.hccake.ballcat.common.core.exception.BusinessException;
import com.hccake.ballcat.common.model.domain.PageParam;
import com.hccake.ballcat.common.model.domain.PageResult;
import com.hccake.ballcat.common.model.result.BaseResultCode;
import com.hccake.ballcat.common.model.result.SystemResultCode;
import com.hccake.ballcat.file.service.FileService;
import com.hccake.ballcat.notify.converter.AnnouncementConverter;
import com.hccake.ballcat.notify.converter.NotifyInfoConverter;
import com.hccake.ballcat.notify.enums.AnnouncementStatusEnum;
import com.hccake.ballcat.notify.event.AnnouncementCloseEvent;
import com.hccake.ballcat.notify.event.NotifyPublishEvent;
import com.hccake.ballcat.notify.mapper.AnnouncementMapper;
import com.hccake.ballcat.notify.model.domain.AnnouncementNotifyInfo;
import com.hccake.ballcat.notify.model.domain.NotifyInfo;
import com.hccake.ballcat.notify.model.dto.AnnouncementDTO;
import com.hccake.ballcat.notify.model.entity.Announcement;
import com.hccake.ballcat.notify.model.qo.AnnouncementQO;
import com.hccake.ballcat.notify.model.vo.AnnouncementPageVO;
import com.hccake.ballcat.notify.service.AnnouncementService;
import com.hccake.extend.mybatis.plus.service.impl.ExtendServiceImpl;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class AnnouncementServiceImpl
extends ExtendServiceImpl<AnnouncementMapper, Announcement>
implements AnnouncementService {
    private static final Logger log = LoggerFactory.getLogger(AnnouncementServiceImpl.class);
    private final ApplicationEventPublisher publisher;
    private final FileService fileService;

    @Override
    public PageResult<AnnouncementPageVO> queryPage(PageParam pageParam, AnnouncementQO qo) {
        return ((AnnouncementMapper)this.baseMapper).queryPage(pageParam, qo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean addAnnouncement(AnnouncementDTO announcementDTO) {
        boolean isPublishStatus;
        Announcement announcement = AnnouncementConverter.INSTANCE.dtoToPo(announcementDTO);
        announcement.setId(null);
        int flag = ((AnnouncementMapper)this.baseMapper).insert(announcement);
        boolean inserted = SqlHelper.retBool((Integer)flag);
        boolean bl = isPublishStatus = announcement.getStatus().intValue() == AnnouncementStatusEnum.ENABLED.getValue();
        if (inserted && isPublishStatus) {
            this.onAnnouncementPublish(announcement);
        }
        return inserted;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateAnnouncement(AnnouncementDTO announcementDTO) {
        boolean isUpdated;
        boolean isPublishStatus;
        Announcement oldAnnouncement = (Announcement)((AnnouncementMapper)this.baseMapper).selectById(announcementDTO.getId());
        if (oldAnnouncement.getStatus().intValue() != AnnouncementStatusEnum.UNPUBLISHED.getValue()) {
            throw new BusinessException(SystemResultCode.BAD_REQUEST.getCode().intValue(), "\u4e0d\u5141\u8bb8\u4fee\u6539\u5df2\u7ecf\u53d1\u5e03\u8fc7\u7684\u516c\u544a\uff01");
        }
        Announcement announcement = AnnouncementConverter.INSTANCE.dtoToPo(announcementDTO);
        boolean bl = isPublishStatus = announcement.getStatus().intValue() == AnnouncementStatusEnum.ENABLED.getValue();
        if (!isPublishStatus) {
            announcement.setStatus(null);
        }
        if ((isUpdated = ((AnnouncementMapper)this.baseMapper).updateIfUnpublished(announcement)) && isPublishStatus) {
            this.onAnnouncementPublish(announcement);
        }
        return isUpdated;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean publish(Long announcementId) {
        Announcement announcement = (Announcement)((AnnouncementMapper)this.baseMapper).selectById(announcementId);
        if (announcement.getStatus().intValue() != AnnouncementStatusEnum.UNPUBLISHED.getValue()) {
            throw new BusinessException(SystemResultCode.BAD_REQUEST.getCode().intValue(), "\u4e0d\u5141\u8bb8\u4fee\u6539\u5df2\u7ecf\u53d1\u5e03\u8fc7\u7684\u516c\u544a\uff01");
        }
        if (BooleanEnum.TRUE.intValue().equals(announcement.getImmortal()) && LocalDateTime.now().isAfter(announcement.getDeadline())) {
            throw new BusinessException(SystemResultCode.BAD_REQUEST.getCode().intValue(), "\u516c\u544a\u5931\u6548\u65f6\u95f4\u5fc5\u987b\u8fdf\u4e8e\u5f53\u524d\u65f6\u95f4\uff01");
        }
        Announcement entity = new Announcement();
        entity.setId(announcementId);
        entity.setStatus(Integer.valueOf(AnnouncementStatusEnum.ENABLED.getValue()));
        boolean isUpdated = ((AnnouncementMapper)this.baseMapper).updateIfUnpublished(entity);
        if (isUpdated) {
            announcement.setStatus(Integer.valueOf(AnnouncementStatusEnum.ENABLED.getValue()));
            this.onAnnouncementPublish(announcement);
        }
        return isUpdated;
    }

    @Override
    public boolean close(Long announcementId) {
        Announcement announcement = new Announcement();
        announcement.setId(announcementId);
        announcement.setStatus(Integer.valueOf(AnnouncementStatusEnum.DISABLED.getValue()));
        int flag = ((AnnouncementMapper)this.baseMapper).updateById(announcement);
        boolean isUpdated = SqlHelper.retBool((Integer)flag);
        if (isUpdated) {
            this.publisher.publishEvent((Object)new AnnouncementCloseEvent(announcementId));
        }
        return isUpdated;
    }

    @Override
    public List<String> uploadImages(List<MultipartFile> files) {
        ArrayList<String> objectNames = new ArrayList<String>();
        for (MultipartFile file : files) {
            String objectName = "announcement/" + LocalDate.now().format(DateTimeFormatter.BASIC_ISO_DATE) + "/" + IdUtil.fastSimpleUUID() + "." + FileUtil.extName((String)file.getOriginalFilename());
            try {
                objectName = this.fileService.upload(file.getInputStream(), objectName, Long.valueOf(file.getSize()));
                objectNames.add(objectName);
            }
            catch (IOException e) {
                throw new BusinessException(BaseResultCode.FILE_UPLOAD_ERROR.getCode().intValue(), "\u56fe\u7247\u4e0a\u4f20\u5931\u8d25\uff01", (Throwable)e);
            }
        }
        return objectNames;
    }

    @Override
    public List<Announcement> listUnPulled(Long userId) {
        return ((AnnouncementMapper)this.baseMapper).listUserAnnouncements(userId, false);
    }

    @Override
    public List<Announcement> listActiveAnnouncements(Long userId) {
        return ((AnnouncementMapper)this.baseMapper).listUserAnnouncements(userId, true);
    }

    private void onAnnouncementPublish(Announcement announcement) {
        AnnouncementNotifyInfo notifyInfo = NotifyInfoConverter.INSTANCE.fromAnnouncement(announcement);
        this.publisher.publishEvent((ApplicationEvent)new NotifyPublishEvent((NotifyInfo)notifyInfo));
    }

    public AnnouncementServiceImpl(ApplicationEventPublisher publisher, FileService fileService) {
        this.publisher = publisher;
        this.fileService = fileService;
    }
}

