/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.autoconfigure.log;

import com.hccake.ballcat.autoconfigure.log.properties.AccessLogProperties;
import com.hccake.ballcat.common.log.access.filter.AccessLogFilter;
import com.hccake.ballcat.common.log.access.handler.AccessLogHandler;
import javax.servlet.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;

@ConditionalOnWebApplication
@EnableConfigurationProperties(value={AccessLogProperties.class})
@ConditionalOnProperty(prefix="ballcat.log.access", name={"enabled"}, matchIfMissing=true, havingValue="true")
public class AccessLogAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(AccessLogAutoConfiguration.class);
    private final AccessLogHandler<?> accessLogService;
    private final AccessLogProperties accessLogProperties;

    @Bean
    @ConditionalOnClass(value={AccessLogHandler.class})
    public FilterRegistrationBean<AccessLogFilter> accessLogFilterRegistrationBean() {
        log.debug("access log \u8bb0\u5f55\u62e6\u622a\u5668\u5df2\u5f00\u542f====");
        FilterRegistrationBean registrationBean = new FilterRegistrationBean((Filter)new AccessLogFilter(this.accessLogService, this.accessLogProperties.getIgnoreUrlPatterns()), new ServletRegistrationBean[0]);
        registrationBean.setOrder(this.accessLogProperties.getFilterOrder().intValue());
        return registrationBean;
    }

    public AccessLogAutoConfiguration(AccessLogHandler<?> accessLogService, AccessLogProperties accessLogProperties) {
        this.accessLogService = accessLogService;
        this.accessLogProperties = accessLogProperties;
    }
}

