/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.common.oss;

import com.hccake.ballcat.common.oss.OssProperties;
import com.hccake.ballcat.common.oss.OssTemplate;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.time.Duration;
import java.util.List;
import javax.activation.MimetypesFileTypeMap;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.S3AsyncClientBuilder;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.S3Configuration;
import software.amazon.awssdk.services.s3.model.DeleteBucketRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketResponse;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectResponse;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.ListObjectsRequest;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectResponse;
import software.amazon.awssdk.services.s3.model.S3Exception;
import software.amazon.awssdk.services.s3.model.S3Object;
import software.amazon.awssdk.services.s3.presigner.S3Presigner;
import software.amazon.awssdk.services.s3.presigner.model.GetObjectPresignRequest;
import software.amazon.awssdk.services.s3.presigner.model.PresignedGetObjectRequest;
import software.amazon.awssdk.transfer.s3.S3TransferManager;
import software.amazon.awssdk.transfer.s3.model.FileUpload;
import software.amazon.awssdk.transfer.s3.model.Upload;
import software.amazon.awssdk.transfer.s3.model.UploadFileRequest;
import software.amazon.awssdk.transfer.s3.model.UploadRequest;

public class DefaultOssTemplate
implements InitializingBean,
DisposableBean,
OssTemplate {
    protected final OssProperties ossProperties;
    protected S3Client s3Client;
    protected S3Presigner s3Presigner;
    protected AwsCredentialsProvider awsCredentialsProvider;
    protected S3TransferManager s3TransferManager;

    @Override
    public DeleteBucketResponse deleteBucket(DeleteBucketRequest deleteBucketRequest) {
        return this.s3Client.deleteBucket(deleteBucketRequest);
    }

    @Override
    public DeleteBucketResponse deleteBucket(String bucket) {
        return this.deleteBucket((DeleteBucketRequest)DeleteBucketRequest.builder().bucket(bucket).build());
    }

    @Override
    public List<S3Object> listObjects(String prefix) {
        return this.listObjects(this.ossProperties.getBucket(), prefix);
    }

    @Override
    public List<S3Object> listObjects(String bucket, String prefix) {
        return this.listObjects(bucket, prefix, 1000);
    }

    @Override
    public List<S3Object> listObjects(String bucket, String prefix, Integer maxKeys) {
        return this.s3Client.listObjects((ListObjectsRequest)ListObjectsRequest.builder().maxKeys(maxKeys).prefix(prefix).bucket(bucket).build()).contents();
    }

    @Override
    public PutObjectResponse putObject(String bucket, String key, File file) throws AwsServiceException, SdkClientException, S3Exception, IOException {
        return this.s3Client.putObject((PutObjectRequest)PutObjectRequest.builder().bucket(bucket).key(key).contentLength(Long.valueOf(file.length())).contentType(MimetypesFileTypeMap.getDefaultFileTypeMap().getContentType(file)).build(), RequestBody.fromFile((File)file));
    }

    @Override
    public DeleteObjectResponse deleteObject(DeleteObjectRequest deleteObjectRequest) {
        return this.s3Client.deleteObject(deleteObjectRequest);
    }

    @Override
    public DeleteObjectResponse deleteObject(String key) {
        return this.deleteObject(this.ossProperties.getBucket(), key);
    }

    @Override
    public DeleteObjectResponse deleteObject(String bucket, String key) {
        return this.deleteObject((DeleteObjectRequest)DeleteObjectRequest.builder().bucket(bucket).key(key).build());
    }

    @Override
    public FileUpload uploadFile(UploadFileRequest uploadFileRequest) {
        return this.s3TransferManager.uploadFile(uploadFileRequest);
    }

    @Override
    public Upload upload(UploadRequest uploadRequest) {
        return this.s3TransferManager.upload(uploadRequest);
    }

    @Override
    public String getObjectPresignedUrl(String bucket, String key, Duration duration) {
        GetObjectRequest getObjectRequest = (GetObjectRequest)GetObjectRequest.builder().bucket(bucket).key(key).build();
        GetObjectPresignRequest getObjectPresignRequest = GetObjectPresignRequest.builder().signatureDuration(duration).getObjectRequest(getObjectRequest).build();
        PresignedGetObjectRequest presignedGetObjectRequest = this.s3Presigner.presignGetObject(getObjectPresignRequest);
        URL url = presignedGetObjectRequest.url();
        return url.toString();
    }

    public void afterPropertiesSet() throws Exception {
        AwsBasicCredentials awsCredentials = AwsBasicCredentials.create((String)this.ossProperties.getAccessKey(), (String)this.ossProperties.getAccessSecret());
        this.awsCredentialsProvider = StaticCredentialsProvider.create((AwsCredentials)awsCredentials);
        this.s3Client = (S3Client)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)S3Client.builder().credentialsProvider(this.awsCredentialsProvider)).region(Region.of((String)this.ossProperties.getRegion()))).serviceConfiguration((S3Configuration)S3Configuration.builder().pathStyleAccessEnabled(this.ossProperties.getPathStyleAccess()).chunkedEncodingEnabled(this.ossProperties.getChunkedEncoding()).build())).endpointOverride(URI.create(this.ossProperties.getEndpoint()))).build();
        this.s3Presigner = S3Presigner.builder().serviceConfiguration((S3Configuration)S3Configuration.builder().pathStyleAccessEnabled(this.ossProperties.getPathStyleAccess()).build()).region(Region.of((String)this.ossProperties.getRegion())).endpointOverride(URI.create(this.ossProperties.getEndpoint())).credentialsProvider(this.awsCredentialsProvider).build();
        this.s3TransferManager = S3TransferManager.builder().s3Client((S3AsyncClient)((S3AsyncClientBuilder)((S3AsyncClientBuilder)((S3AsyncClientBuilder)S3AsyncClient.builder().credentialsProvider(this.getAwsCredentialsProvider())).region(Region.of((String)this.getOssProperties().getRegion()))).endpointOverride(URI.create(this.getOssProperties().getEndpoint()))).build()).build();
    }

    public void destroy() throws Exception {
        if (this.s3Client != null) {
            this.s3Client.close();
        }
        if (this.s3Presigner != null) {
            this.s3Presigner.close();
        }
        if (this.s3TransferManager != null) {
            this.s3TransferManager.close();
        }
    }

    public DefaultOssTemplate(OssProperties ossProperties) {
        this.ossProperties = ossProperties;
    }

    @Override
    public OssProperties getOssProperties() {
        return this.ossProperties;
    }

    @Override
    public S3Client getS3Client() {
        return this.s3Client;
    }

    @Override
    public S3Presigner getS3Presigner() {
        return this.s3Presigner;
    }

    @Override
    public AwsCredentialsProvider getAwsCredentialsProvider() {
        return this.awsCredentialsProvider;
    }

    @Override
    public S3TransferManager getS3TransferManager() {
        return this.s3TransferManager;
    }
}

