/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.common.oss;

import com.hccake.ballcat.common.oss.DefaultOssTemplate;
import com.hccake.ballcat.common.oss.OssProperties;
import com.hccake.ballcat.common.oss.prefix.ObjectKeyPrefixConverter;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.util.StringUtils;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectResponse;
import software.amazon.awssdk.services.s3.model.ListObjectsRequest;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectResponse;
import software.amazon.awssdk.services.s3.model.S3Exception;
import software.amazon.awssdk.services.s3.model.S3Object;
import software.amazon.awssdk.transfer.s3.model.FileUpload;

public class ObjectWithGlobalKeyPrefixOssTemplate
extends DefaultOssTemplate {
    private final ObjectKeyPrefixConverter objectKeyPrefixConverter;

    public ObjectWithGlobalKeyPrefixOssTemplate(OssProperties ossProperties, ObjectKeyPrefixConverter objectKeyPrefixConverter) {
        super(ossProperties);
        this.objectKeyPrefixConverter = objectKeyPrefixConverter;
    }

    @Override
    public List<S3Object> listObjects(String bucket, String prefix, Integer maxKeys) {
        List contents = this.s3Client.listObjects((ListObjectsRequest)ListObjectsRequest.builder().bucket(bucket).maxKeys(maxKeys).prefix(this.objectKeyPrefixConverter.wrap(prefix)).build()).contents();
        return this.objectKeyPrefixConverter.match() ? contents.stream().map(ele -> (S3Object)S3Object.builder().checksumAlgorithm((Collection)ele.checksumAlgorithm()).checksumAlgorithmWithStrings((Collection)ele.checksumAlgorithmAsStrings()).eTag(ele.eTag()).lastModified(ele.lastModified()).key(this.objectKeyPrefixConverter.unwrap(ele.key())).owner(ele.owner()).size(ele.size()).storageClass(ele.storageClass()).build()).collect(Collectors.toList()) : contents;
    }

    @Override
    public PutObjectResponse putObject(String bucket, String key, File file) throws AwsServiceException, SdkClientException, S3Exception, IOException {
        return super.putObject(bucket, this.objectKeyPrefixConverter.wrap(key), file);
    }

    @Override
    public PutObjectResponse putObject(PutObjectRequest putObjectRequest, RequestBody requestBody) throws AwsServiceException, SdkClientException, S3Exception {
        if (StringUtils.hasText((String)putObjectRequest.key())) {
            return super.putObject((PutObjectRequest)PutObjectRequest.builder().acl(putObjectRequest.acl()).contentType(putObjectRequest.contentType()).key(this.objectKeyPrefixConverter.wrap(putObjectRequest.key())).bucket(putObjectRequest.bucket()).contentLength(putObjectRequest.contentLength()).cacheControl(putObjectRequest.cacheControl()).metadata(putObjectRequest.metadata()).checksumAlgorithm(putObjectRequest.checksumAlgorithm()).checksumCRC32(putObjectRequest.checksumCRC32()).checksumCRC32C(putObjectRequest.checksumCRC32C()).checksumSHA1(putObjectRequest.checksumSHA1()).checksumSHA256(putObjectRequest.checksumSHA256()).bucketKeyEnabled(putObjectRequest.bucketKeyEnabled()).contentEncoding(putObjectRequest.contentEncoding()).contentMD5(putObjectRequest.contentMD5()).websiteRedirectLocation(putObjectRequest.websiteRedirectLocation()).expectedBucketOwner(putObjectRequest.expectedBucketOwner()).expires(putObjectRequest.expires()).grantFullControl(putObjectRequest.grantFullControl()).grantRead(putObjectRequest.grantRead()).grantReadACP(putObjectRequest.grantReadACP()).grantWriteACP(putObjectRequest.grantWriteACP()).contentLanguage(putObjectRequest.contentLanguage()).objectLockMode(putObjectRequest.objectLockMode()).objectLockLegalHoldStatus(putObjectRequest.objectLockLegalHoldStatus()).objectLockRetainUntilDate(putObjectRequest.objectLockRetainUntilDate()).overrideConfiguration((AwsRequestOverrideConfiguration)putObjectRequest.overrideConfiguration().orElse(null)).requestPayer(putObjectRequest.requestPayer()).serverSideEncryption(putObjectRequest.serverSideEncryption()).sseCustomerAlgorithm(putObjectRequest.sseCustomerAlgorithm()).sseCustomerKey(putObjectRequest.sseCustomerKey()).sseCustomerKeyMD5(putObjectRequest.sseCustomerKeyMD5()).ssekmsEncryptionContext(putObjectRequest.ssekmsEncryptionContext()).ssekmsKeyId(putObjectRequest.ssekmsKeyId()).contentDisposition(putObjectRequest.contentDisposition()).tagging(putObjectRequest.tagging()).build(), requestBody);
        }
        return super.putObject(putObjectRequest, requestBody);
    }

    @Override
    public DeleteObjectResponse deleteObject(String bucket, String key) {
        return super.deleteObject(bucket, this.objectKeyPrefixConverter.wrap(key));
    }

    @Override
    public DeleteObjectResponse deleteObject(DeleteObjectRequest deleteObjectRequest) {
        if (StringUtils.hasText((String)deleteObjectRequest.key())) {
            return super.deleteObject((DeleteObjectRequest)DeleteObjectRequest.builder().bucket(deleteObjectRequest.bucket()).key(this.objectKeyPrefixConverter.wrap(deleteObjectRequest.key())).bypassGovernanceRetention(deleteObjectRequest.bypassGovernanceRetention()).expectedBucketOwner(deleteObjectRequest.expectedBucketOwner()).mfa(deleteObjectRequest.mfa()).overrideConfiguration((AwsRequestOverrideConfiguration)deleteObjectRequest.overrideConfiguration().orElse(null)).requestPayer(deleteObjectRequest.requestPayer()).versionId(deleteObjectRequest.versionId()).build());
        }
        return super.deleteObject(deleteObjectRequest);
    }

    @Override
    public String getURL(String bucket, String key) {
        return super.getURL(bucket, this.objectKeyPrefixConverter.wrap(key));
    }

    @Override
    public String getObjectPresignedUrl(String bucket, String key, Duration duration) {
        return super.getObjectPresignedUrl(bucket, this.objectKeyPrefixConverter.wrap(key), duration);
    }

    @Override
    public FileUpload uploadFile(String bucket, String key, File file) {
        return super.uploadFile(bucket, this.objectKeyPrefixConverter.wrap(key), file);
    }

    public ObjectKeyPrefixConverter getObjectKeyPrefixConverter() {
        return this.objectKeyPrefixConverter;
    }
}

