/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.common.oss;

import com.hccake.ballcat.common.oss.DefaultOssTemplate;
import com.hccake.ballcat.common.oss.ObjectWithGlobalKeyPrefixOssTemplate;
import com.hccake.ballcat.common.oss.OssClient;
import com.hccake.ballcat.common.oss.OssProperties;
import com.hccake.ballcat.common.oss.OssTemplate;
import com.hccake.ballcat.common.oss.prefix.DefaultObjectKeyPrefixConverter;
import com.hccake.ballcat.common.oss.prefix.ObjectKeyPrefixConverter;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@EnableConfigurationProperties(value={OssProperties.class})
@ConditionalOnProperty(prefix="ballcat.oss", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class OssAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={OssTemplate.class})
    public OssTemplate ossTemplate(OssProperties properties, ObjectKeyPrefixConverter objectKeyPrefixConverter) {
        if (objectKeyPrefixConverter.match()) {
            return new ObjectWithGlobalKeyPrefixOssTemplate(properties, objectKeyPrefixConverter);
        }
        return new DefaultOssTemplate(properties);
    }

    @Bean
    @ConditionalOnMissingBean(value={ObjectKeyPrefixConverter.class})
    public ObjectKeyPrefixConverter objectPrefixConverter(OssProperties properties) {
        return new DefaultObjectKeyPrefixConverter(properties);
    }

    @Bean
    @ConditionalOnMissingBean(value={OssClient.class})
    public OssClient ossClient(OssTemplate ossTemplate, ObjectKeyPrefixConverter objectKeyPrefixConverter) {
        return new OssClient(ossTemplate, objectKeyPrefixConverter);
    }
}

