/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.common.oss;

import com.hccake.ballcat.common.oss.OssProperties;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.lang.NonNull;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.BucketAlreadyExistsException;
import software.amazon.awssdk.services.s3.model.BucketAlreadyOwnedByYouException;
import software.amazon.awssdk.services.s3.model.CreateBucketConfiguration;
import software.amazon.awssdk.services.s3.model.CreateBucketRequest;
import software.amazon.awssdk.services.s3.model.CreateBucketResponse;
import software.amazon.awssdk.services.s3.model.DeleteBucketRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketResponse;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectResponse;
import software.amazon.awssdk.services.s3.model.GetUrlRequest;
import software.amazon.awssdk.services.s3.model.ListBucketsRequest;
import software.amazon.awssdk.services.s3.model.ListBucketsResponse;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectResponse;
import software.amazon.awssdk.services.s3.model.S3Exception;
import software.amazon.awssdk.services.s3.model.S3Object;
import software.amazon.awssdk.services.s3.presigner.S3Presigner;
import software.amazon.awssdk.transfer.s3.S3TransferManager;
import software.amazon.awssdk.transfer.s3.model.FileUpload;
import software.amazon.awssdk.transfer.s3.model.Upload;
import software.amazon.awssdk.transfer.s3.model.UploadFileRequest;
import software.amazon.awssdk.transfer.s3.model.UploadRequest;

public interface OssTemplate {
    @NonNull
    public OssProperties getOssProperties();

    @NonNull
    public S3Client getS3Client();

    @NonNull
    public AwsCredentialsProvider getAwsCredentialsProvider();

    @NonNull
    public S3Presigner getS3Presigner();

    @NonNull
    public S3TransferManager getS3TransferManager();

    default public CreateBucketResponse createBucket(CreateBucketRequest createBucketRequest) throws BucketAlreadyExistsException, BucketAlreadyOwnedByYouException, AwsServiceException, SdkClientException, S3Exception {
        return this.getS3Client().createBucket(createBucketRequest);
    }

    default public CreateBucketResponse createBucket(String bucket) throws BucketAlreadyExistsException, BucketAlreadyOwnedByYouException, AwsServiceException, SdkClientException, S3Exception {
        return this.createBucket((CreateBucketRequest)CreateBucketRequest.builder().bucket(bucket).build());
    }

    default public CreateBucketResponse createBucket(String bucket, Region region) throws BucketAlreadyExistsException, BucketAlreadyOwnedByYouException, AwsServiceException, SdkClientException, S3Exception {
        return this.createBucket(bucket, region.id());
    }

    default public CreateBucketResponse createBucket(String bucket, String region) throws BucketAlreadyExistsException, BucketAlreadyOwnedByYouException, AwsServiceException, SdkClientException, S3Exception {
        return this.createBucket((CreateBucketRequest)CreateBucketRequest.builder().createBucketConfiguration((CreateBucketConfiguration)CreateBucketConfiguration.builder().locationConstraint(region).build()).bucket(bucket).build());
    }

    default public ListBucketsResponse listBuckets(ListBucketsRequest listBucketsRequest) throws AwsServiceException, SdkClientException, S3Exception {
        return this.getS3Client().listBuckets(listBucketsRequest);
    }

    default public ListBucketsResponse listBuckets() throws AwsServiceException, SdkClientException, S3Exception {
        return this.getS3Client().listBuckets();
    }

    default public DeleteBucketResponse deleteBucket(DeleteBucketRequest deleteBucketRequest) {
        return this.getS3Client().deleteBucket(deleteBucketRequest);
    }

    default public DeleteBucketResponse deleteBucket(String bucket) {
        return this.deleteBucket((DeleteBucketRequest)DeleteBucketRequest.builder().bucket(bucket).build());
    }

    default public List<S3Object> listObjects(String prefix) {
        return this.listObjects(this.getOssProperties().getBucket(), prefix);
    }

    default public List<S3Object> listObjects(String bucket, String prefix) {
        return this.listObjects(bucket, prefix, 1000);
    }

    public List<S3Object> listObjects(String var1, String var2, Integer var3);

    public PutObjectResponse putObject(String var1, String var2, File var3) throws AwsServiceException, SdkClientException, S3Exception, IOException;

    default public PutObjectResponse putObject(PutObjectRequest putObjectRequest, RequestBody requestBody) throws AwsServiceException, SdkClientException, S3Exception {
        return this.getS3Client().putObject(putObjectRequest, requestBody);
    }

    default public DeleteObjectResponse deleteObject(DeleteObjectRequest deleteObjectRequest) {
        return this.getS3Client().deleteObject(deleteObjectRequest);
    }

    default public DeleteObjectResponse deleteObject(String key) {
        return this.deleteObject(this.getOssProperties().getBucket(), key);
    }

    default public DeleteObjectResponse deleteObject(String bucket, String key) {
        return this.getS3Client().deleteObject((DeleteObjectRequest)DeleteObjectRequest.builder().bucket(bucket).key(key).build());
    }

    default public String getURL(String bucket, String key) {
        return this.getS3Client().utilities().getUrl((GetUrlRequest)GetUrlRequest.builder().key(key).bucket(bucket).build()).toString();
    }

    default public String getURL(String key) {
        return this.getURL(this.getOssProperties().getBucket(), key);
    }

    public String getObjectPresignedUrl(String var1, String var2, Duration var3);

    default public String getObjectPresignedUrl(String bucket, String keyName) {
        return this.getObjectPresignedUrl(bucket, keyName, Duration.ofHours(2L));
    }

    default public String getObjectPresignedUrl(String keyName) {
        return this.getObjectPresignedUrl(this.getOssProperties().getBucket(), keyName, Duration.ofHours(2L));
    }

    default public FileUpload uploadFile(String bucket, String key, File file) {
        return this.getS3TransferManager().uploadFile((UploadFileRequest)UploadFileRequest.builder().putObjectRequest((PutObjectRequest)PutObjectRequest.builder().bucket(bucket).key(key).build()).source(file).build());
    }

    default public FileUpload uploadFile(String key, File file) {
        return this.uploadFile(this.getOssProperties().getBucket(), key, file);
    }

    default public FileUpload uploadFile(File file) {
        return this.uploadFile(this.getOssProperties().getBucket(), file.getName(), file);
    }

    public FileUpload uploadFile(UploadFileRequest var1);

    default public FileUpload uploadFile(Consumer<UploadFileRequest.Builder> request) {
        return this.uploadFile((UploadFileRequest)((UploadFileRequest.Builder)UploadFileRequest.builder().applyMutation(request)).build());
    }

    default public Upload upload(UploadRequest uploadRequest) {
        return this.getS3TransferManager().upload(uploadRequest);
    }

    default public Upload upload(Consumer<UploadRequest.Builder> request) {
        return this.upload(((UploadRequest.Builder)UploadRequest.builder().applyMutation(request)).build());
    }
}

