/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.common.oss.prefix;

import com.hccake.ballcat.common.oss.OssProperties;
import com.hccake.ballcat.common.oss.prefix.ObjectKeyPrefixConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class DefaultObjectKeyPrefixConverter
implements ObjectKeyPrefixConverter,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(DefaultObjectKeyPrefixConverter.class);
    private final OssProperties properties;
    private String globalObjectPrefix;

    @Override
    public String getPrefix() {
        return this.properties.getObjectKeyPrefix();
    }

    @Override
    public boolean match() {
        return StringUtils.hasText((String)this.getPrefix()) && StringUtils.hasText((String)this.globalObjectPrefix);
    }

    @Override
    public String unwrap(String key) {
        return this.match() && key.startsWith(this.globalObjectPrefix) ? key.substring(this.globalObjectPrefix.length()) : key;
    }

    @Override
    public String wrap(String key) {
        return this.match() ? this.globalObjectPrefix + key : key;
    }

    public void afterPropertiesSet() throws Exception {
        String configPrefix = this.getPrefix();
        if (ObjectUtils.isEmpty((Object)configPrefix)) {
            log.info("\u672a\u914d\u7f6e\u5168\u5c40\u524d\u7f00\u914d\u7f6e,\u5168\u5c40\u524d\u7f00\u7ec4\u7ec7\u5bf9\u8c61\u529f\u80fd\u4e0d\u542f\u7528");
            return;
        }
        if ("/".equals(configPrefix)) {
            log.warn("\u5168\u5c40\u524d\u7f00\u8def\u5f84\u4e3a\u975e\u6cd5\u914d\u7f6e:[{}],\u5168\u5c40\u8def\u5f84\u4e0d\u8d77\u6548,\u5168\u5c40\u524d\u7f00\u7ec4\u7ec7\u5bf9\u8c61\u529f\u80fd\u4e0d\u542f\u7528", (Object)"/");
            return;
        }
        this.globalObjectPrefix = configPrefix;
        if (this.globalObjectPrefix.startsWith("/")) {
            this.globalObjectPrefix = this.globalObjectPrefix.substring(1);
        }
        if (!this.globalObjectPrefix.endsWith("/")) {
            this.globalObjectPrefix = this.globalObjectPrefix + "/";
        }
        if (log.isInfoEnabled()) {
            log.info("\u5168\u5c40\u524d\u7f00\u7ec4\u7ec7\u5bf9\u8c61\u529f\u80fd\u542f\u7528\uff0c\u5168\u5c40\u524d\u7f00\u914d\u7f6e\u8def\u5f84\u4e3a:[{}],\u6807\u51c6\u5316\u524d\u7f00\u5168\u5c40\u524d\u7f00\u8def\u5f84\u4e3a:[{}]", (Object)configPrefix, (Object)this.globalObjectPrefix);
            log.info("\u5b58\u5728\u5168\u5c40\u524d\u7f00\u65f6\uff0c\u9488\u5bf9\u7528\u6237\u64cd\u4f5cOSS\u5bf9\u8c61(\u4e0a\u4f20\u3001\u5220\u9664)\u7684\u90e8\u5206\u4f1a\u81ea\u52a8\u62fc\u63a5\u5168\u5c40\u524d\u7f00\uff0c\u9488\u5bf9\u7528\u6237\u8bfb\u53d6OSS\u5bf9\u8c61\u7684\u90e8\u5206\uff0c\u8fd4\u56de\u7684OSS\u5bf9\u8c61\u4f1a\u81ea\u52a8\u79fb\u9664\u5168\u5c40\u524d\u7f00,\u4f46\u5b9e\u9645\u5b58\u50a8\u5728OSS\u7684\u4f4d\u7f6e\u4e5f\u4f1a\u5305\u542b\u5168\u5c40\u8def\u5f84");
            log.info("\u4f8b\u5982,\u5b58\u5728`abc`\u6876\u65f6\uff0c\u5168\u5c40\u524d\u7f00\u8bbe\u7f6e\u4e3a`d`\u65f6,\u4e0a\u4f20OSS\u5bf9\u8c61`e.txt`\u65f6,OSS\u5bf9\u8c61\u4f1a\u6309\u7167`d/e.txt`\u4fdd\u5b58\uff0c\u7528\u6237\u5728\u5177\u6709\u6743\u9650\u65f6\u53ef\u901a\u8fc7\u8d44\u6e90`{}/abc/d/e.txt`\u8bbf\u95ee\u8be5\u8d44\u6e90", (Object)this.properties.getEndpoint());
            log.info("\u7528\u6237\u8bd5\u56fe\u67e5\u627e\u8be5\u8d44\u6e90\u65f6\uff0c\u53ea\u9700\u8981\u4f20\u5165`e.txt`,\u63d2\u4ef6\u4f1a\u81ea\u52a8\u53d1\u8d77\u5bf9`d/e.txt`\u8def\u5f84\u7684\u67e5\u8be2,\u8fd4\u56de\u7684OSS\u5bf9\u8c61\u4e5f\u4f1a\u53bb\u9664\u67e5\u8be2\u5230\u7684\u5bf9\u8c61\u540d\u79f0\u5c06\u4e3a`e.txt`");
            log.info("\u7528\u6237\u8bd5\u56fe\u5220\u9664\u8be5\u8d44\u6e90\u65f6\uff0c\u53ea\u9700\u8981\u4f20\u5165`e.txt`,\u63d2\u4ef6\u4f1a\u81ea\u52a8\u53d1\u8d77\u5bf9`d/e.txt`\u8def\u5f84\u5bf9\u8c61\u7684\u5220\u9664");
        }
    }

    public DefaultObjectKeyPrefixConverter(OssProperties properties) {
        this.properties = properties;
    }
}

