/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.autoconfigure.web.actuate;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SecureUtil;
import com.hccake.ballcat.common.model.result.R;
import com.hccake.ballcat.common.model.result.ResultCode;
import com.hccake.ballcat.common.model.result.SystemResultCode;
import com.hccake.ballcat.common.util.JsonUtils;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpStatus;
import org.springframework.web.filter.OncePerRequestFilter;

public class ActuatorSecurityFilter
extends OncePerRequestFilter {
    private final String secretId;
    private final String secretKey;

    public ActuatorSecurityFilter(String secretId, String secretKey) {
        this.secretId = secretId;
        this.secretKey = secretKey;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String reqTime;
        String sign;
        String reqSecretId = request.getHeader("secretId");
        if (this.verifySign(reqSecretId, sign = request.getHeader("sign"), reqTime = request.getHeader("reqTime"))) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        } else {
            response.setHeader("Content-Type", "application/json;charset=UTF-8");
            response.setStatus(HttpStatus.UNAUTHORIZED.value());
            R r = R.failed((ResultCode)SystemResultCode.UNAUTHORIZED);
            response.getWriter().write(JsonUtils.toJson((Object)r));
        }
    }

    private boolean verifySign(String reqSecretId, String sign, String reqTime) {
        if (CharSequenceUtil.isNotBlank((CharSequence)sign) && CharSequenceUtil.isNotBlank((CharSequence)reqTime) && CharSequenceUtil.isNotBlank((CharSequence)reqSecretId)) {
            if (!reqSecretId.equals(this.secretId)) {
                return false;
            }
            long expireTime = 30000L;
            long nowTime = System.currentTimeMillis();
            if (nowTime - Long.parseLong(reqTime) <= expireTime) {
                String reverse = StrUtil.reverse((String)reqTime);
                String checkSign = SecureUtil.md5((String)(reverse + this.secretId + this.secretKey));
                return CharSequenceUtil.equalsIgnoreCase((CharSequence)checkSign, (CharSequence)sign);
            }
        }
        return false;
    }
}

