/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.autoconfigure.web.exception;

import com.hccake.ballcat.autoconfigure.web.exception.ExceptionHandleProperties;
import com.hccake.ballcat.autoconfigure.web.exception.handler.DefaultGlobalExceptionHandler;
import com.hccake.ballcat.autoconfigure.web.exception.handler.DingTalkGlobalExceptionHandler;
import com.hccake.ballcat.autoconfigure.web.exception.handler.MailGlobalExceptionHandler;
import com.hccake.ballcat.autoconfigure.web.exception.handler.MultiGlobalExceptionHandler;
import com.hccake.ballcat.autoconfigure.web.exception.resolver.GlobalHandlerExceptionResolver;
import com.hccake.ballcat.autoconfigure.web.exception.resolver.SecurityHandlerExceptionResolver;
import com.hccake.ballcat.common.core.exception.handler.GlobalExceptionHandler;
import com.hccake.ballcat.common.mail.sender.MailSender;
import com.hccake.extend.dingtalk.DingTalkSender;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.util.CollectionUtils;

@AutoConfiguration
@EnableConfigurationProperties(value={ExceptionHandleProperties.class})
public class ExceptionAutoConfiguration {
    @Value(value="${spring.application.name: unknown-application}")
    private String applicationName;

    @Bean
    @Deprecated
    @ConditionalOnMissingBean(value={GlobalExceptionHandler.class})
    @ConditionalOnProperty(prefix="ballcat.exception", matchIfMissing=true, name={"type"}, havingValue="NONE")
    public GlobalExceptionHandler defaultGlobalExceptionHandler() {
        return new DefaultGlobalExceptionHandler();
    }

    @Bean
    @ConditionalOnMissingBean(value={GlobalExceptionHandler.class})
    public GlobalExceptionHandler multiGlobalExceptionHandler(ExceptionHandleProperties properties, ApplicationContext context) {
        if (properties.getType() != null) {
            switch (properties.getType()) {
                case NONE: {
                    return new DefaultGlobalExceptionHandler();
                }
                case MAIL: {
                    return new MailGlobalExceptionHandler(properties, (MailSender)context.getBean(MailSender.class), context.getApplicationName());
                }
            }
            return new DingTalkGlobalExceptionHandler(properties, (DingTalkSender)context.getBean(DingTalkSender.class), context.getApplicationName());
        }
        if (!Boolean.TRUE.equals(properties.getEnabled())) {
            return new DefaultGlobalExceptionHandler();
        }
        Object mailSender = CollectionUtils.isEmpty(properties.getReceiveEmails()) ? null : context.getBean(MailSender.class);
        return new MultiGlobalExceptionHandler(properties, context.getApplicationName(), mailSender);
    }

    @Bean
    @ConditionalOnMissingBean(value={GlobalExceptionHandler.class})
    @ConditionalOnProperty(prefix="ballcat.exception", name={"type"}, havingValue="DING_TALK")
    public GlobalExceptionHandler dingTalkGlobalExceptionHandler(ExceptionHandleProperties exceptionHandleProperties, ApplicationContext context) {
        return new DingTalkGlobalExceptionHandler(exceptionHandleProperties, (DingTalkSender)context.getBean(DingTalkSender.class), this.applicationName);
    }

    @Bean
    @ConditionalOnMissingBean(value={GlobalExceptionHandler.class})
    @ConditionalOnProperty(prefix="ballcat.exception", name={"type"}, havingValue="MAIL")
    public GlobalExceptionHandler mailGlobalExceptionHandler(ExceptionHandleProperties exceptionHandleProperties, ApplicationContext context) {
        return new MailGlobalExceptionHandler(exceptionHandleProperties, (MailSender)context.getBean(MailSender.class), this.applicationName);
    }

    @Bean
    @ConditionalOnMissingBean(value={GlobalHandlerExceptionResolver.class})
    public GlobalHandlerExceptionResolver globalExceptionHandlerResolver(GlobalExceptionHandler globalExceptionHandler) {
        return new GlobalHandlerExceptionResolver(globalExceptionHandler);
    }

    @ConditionalOnClass(value={AccessDeniedException.class})
    static class SecurityExceptionConfiguration {
        SecurityExceptionConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={SecurityHandlerExceptionResolver.class})
        public SecurityHandlerExceptionResolver securityHandlerExceptionResolver(GlobalExceptionHandler globalExceptionHandler) {
            return new SecurityHandlerExceptionResolver(globalExceptionHandler);
        }
    }
}

