/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.autoconfigure.web.exception.handler;

import com.hccake.ballcat.autoconfigure.web.exception.ExceptionHandleProperties;
import com.hccake.ballcat.autoconfigure.web.exception.domain.ExceptionMessage;
import com.hccake.ballcat.autoconfigure.web.exception.domain.ExceptionNoticeResponse;
import com.hccake.ballcat.autoconfigure.web.exception.handler.AbstractNoticeGlobalExceptionHandler;
import com.hccake.ballcat.common.mail.sender.MailSender;
import com.hccake.extend.dingtalk.DingTalkSender;
import com.hccake.extend.dingtalk.message.DingTalkMessage;
import com.hccake.extend.dingtalk.message.DingTalkTextMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class MultiGlobalExceptionHandler
extends AbstractNoticeGlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(MultiGlobalExceptionHandler.class);
    private final Object mailSender;
    private final String[] receiveEmails;
    private final List<Object> dingTalkSenders;

    public MultiGlobalExceptionHandler(ExceptionHandleProperties config, String applicationName, Object mailSender) {
        super(config, applicationName);
        this.mailSender = mailSender;
        this.receiveEmails = CollectionUtils.isEmpty(config.getReceiveEmails()) ? new String[0] : config.getReceiveEmails().toArray(new String[0]);
        ExceptionHandleProperties.DingTalkProperties dingTalkProperties = config.getDingTalk();
        if (dingTalkProperties == null || CollectionUtils.isEmpty(dingTalkProperties.getSenders())) {
            this.dingTalkSenders = new ArrayList<Object>(0);
        } else {
            this.dingTalkSenders = new ArrayList<Object>(dingTalkProperties.getSenders().size());
            for (ExceptionHandleProperties.DingTalkProperties.Sender s : dingTalkProperties.getSenders()) {
                DingTalkSender sender = new DingTalkSender(s.getUrl());
                sender.setSecret(s.getSecret());
                this.dingTalkSenders.add(sender);
            }
        }
    }

    @Override
    public ExceptionNoticeResponse send(ExceptionMessage sendMessage) {
        if (this.receiveEmails != null && this.receiveEmails.length > 0) {
            try {
                String[] to = this.config.getReceiveEmails().toArray(new String[0]);
                ((MailSender)this.mailSender).sendTextMail("\u5f02\u5e38\u8b66\u544a", sendMessage.toString(), to);
            }
            catch (Exception e) {
                log.error("\u90ae\u7bb1\u5f02\u5e38\u901a\u77e5\u53d1\u9001\u5f02\u5e38! emails: {}", (Object)Arrays.toString(this.receiveEmails));
            }
        }
        for (Object obj : this.dingTalkSenders) {
            DingTalkSender sender = (DingTalkSender)obj;
            try {
                DingTalkTextMessage message = new DingTalkTextMessage().setContent(sendMessage.toString());
                if (Boolean.TRUE.equals(this.config.getDingTalk().getAtAll())) {
                    message.atAll();
                }
                sender.sendMessage((DingTalkMessage)message);
            }
            catch (Exception e) {
                log.error("\u9489\u9489\u5f02\u5e38\u901a\u77e5\u53d1\u9001\u5f02\u5e38! webHook: {}", (Object)sender.getUrl(), (Object)e);
            }
        }
        return new ExceptionNoticeResponse().setSuccess(true);
    }
}

