/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.autoconfigure.web.exception.resolver;

import com.hccake.ballcat.common.core.exception.handler.GlobalExceptionHandler;
import com.hccake.ballcat.common.model.result.R;
import com.hccake.ballcat.common.model.result.ResultCode;
import com.hccake.ballcat.common.model.result.SystemResultCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.SpringSecurityMessageSource;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@Order(value=-1000)
@RestControllerAdvice
public class SecurityHandlerExceptionResolver {
    private static final Logger log = LoggerFactory.getLogger(SecurityHandlerExceptionResolver.class);
    private final GlobalExceptionHandler globalExceptionHandler;

    @ExceptionHandler(value={AccessDeniedException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    public R<String> handleAccessDeniedException(AccessDeniedException e) {
        String msg = SpringSecurityMessageSource.getAccessor().getMessage("AbstractAccessDecisionManager.accessDenied", e.getMessage());
        log.error("\u62d2\u7edd\u6388\u6743\u5f02\u5e38\u4fe1\u606f ex={}", (Object)msg);
        this.globalExceptionHandler.handle((Throwable)e);
        return R.failed((ResultCode)SystemResultCode.FORBIDDEN, (String)e.getLocalizedMessage());
    }

    public SecurityHandlerExceptionResolver(GlobalExceptionHandler globalExceptionHandler) {
        this.globalExceptionHandler = globalExceptionHandler;
    }
}

