/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.autoconfigure.web.pageable;

import com.hccake.ballcat.autoconfigure.web.pageable.PageParamArgumentResolver;
import com.hccake.ballcat.autoconfigure.web.pageable.PageParamArgumentResolverSupport;
import com.hccake.ballcat.autoconfigure.web.pageable.PageableProperties;
import com.hccake.ballcat.common.model.domain.PageParam;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.ModelAndViewContainer;

public class DefaultPageParamArgumentResolver
extends PageParamArgumentResolverSupport
implements PageParamArgumentResolver {
    private static final Logger log = LoggerFactory.getLogger(DefaultPageParamArgumentResolver.class);

    public DefaultPageParamArgumentResolver(PageableProperties pageableProperties) {
        this.setMaxPageSize(pageableProperties.getMaxPageSize());
        this.setPageParameterName(pageableProperties.getPageParameterName());
        this.setSizeParameterName(pageableProperties.getSizeParameterName());
        this.setSortParameterName(pageableProperties.getSortParameterName());
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return PageParam.class.isAssignableFrom(parameter.getParameterType());
    }

    @Override
    public PageParam resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        HttpServletRequest request = (HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class);
        if (request == null) {
            return new PageParam();
        }
        PageParam pageParam = this.getPageParam(parameter, request);
        this.paramValidate(parameter, mavContainer, webRequest, binderFactory, pageParam);
        return pageParam;
    }
}

