/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.autoconfigure.web.pageable;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ArrayUtil;
import com.hccake.ballcat.common.model.domain.PageParam;
import com.hccake.ballcat.common.model.domain.PageableConstants;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.ObjectError;
import org.springframework.validation.annotation.ValidationAnnotationUtils;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.ModelAndViewContainer;

public abstract class PageParamArgumentResolverSupport {
    private static final Logger log = LoggerFactory.getLogger(PageParamArgumentResolverSupport.class);
    private String pageParameterName = "page";
    private String sizeParameterName = "size";
    private String sortParameterName = "sort";
    private int maxPageSize = 100;

    protected PageParam getPageParam(MethodParameter parameter, HttpServletRequest request) {
        List<PageParam.Sort> sorts;
        PageParam pageParam;
        String pageParameterValue = request.getParameter(this.pageParameterName);
        String sizeParameterValue = request.getParameter(this.sizeParameterName);
        try {
            pageParam = (PageParam)parameter.getParameterType().newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            pageParam = new PageParam();
        }
        long pageValue = this.parseValueFormString(pageParameterValue, 1L);
        pageParam.setPage(pageValue);
        pageParam.setCurrent(pageValue);
        long sizeValue = this.parseValueFormString(sizeParameterValue, 10L);
        pageParam.setSize(sizeValue);
        Map parameterMap = request.getParameterMap();
        Object[] sort = (String[])parameterMap.get(this.sortParameterName);
        if (ArrayUtil.isEmpty((Object[])sort)) {
            sort = (String[])parameterMap.get(this.sortParameterName + "[]");
        }
        if (ArrayUtil.isNotEmpty((Object[])sort)) {
            sorts = this.getSortList((String[])sort);
        } else {
            String sortFields = request.getParameter("sortFields");
            String sortOrders = request.getParameter("sortOrders");
            sorts = this.getSortList(sortFields, sortOrders);
        }
        pageParam.setSorts(sorts);
        return pageParam;
    }

    private long parseValueFormString(String currentParameterValue, long defaultValue) {
        try {
            return Long.parseLong(currentParameterValue);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    protected List<PageParam.Sort> getSortList(String[] sort) {
        ArrayList<PageParam.Sort> sorts = new ArrayList<PageParam.Sort>();
        for (String sortRule : sort) {
            if (sortRule == null) continue;
            String[] sortRuleArr = sortRule.split(",");
            String field = sortRuleArr[0];
            String order = sortRuleArr.length < 2 ? "asc" : sortRuleArr[1];
            this.fillValidSort(field, order, sorts);
        }
        return sorts;
    }

    @Deprecated
    protected List<PageParam.Sort> getSortList(String sortFields, String sortOrders) {
        String[] orderArr;
        ArrayList<PageParam.Sort> sorts = new ArrayList<PageParam.Sort>();
        if (CharSequenceUtil.isBlank((CharSequence)sortFields) || CharSequenceUtil.isBlank((CharSequence)sortOrders)) {
            return sorts;
        }
        String[] fieldArr = sortFields.split(",");
        if (fieldArr.length != (orderArr = sortOrders.split(",")).length) {
            return sorts;
        }
        for (int i = 0; i < fieldArr.length; ++i) {
            String field = fieldArr[i];
            String order = orderArr[i];
            this.fillValidSort(field, order, sorts);
        }
        return sorts;
    }

    protected void fillValidSort(String field, String order, List<PageParam.Sort> sorts) {
        if (this.validFieldName(field)) {
            PageParam.Sort sort = new PageParam.Sort();
            sort.setAsc("asc".equalsIgnoreCase(order));
            sort.setField(CharSequenceUtil.toUnderlineCase((CharSequence)field));
            sorts.add(sort);
        }
    }

    protected boolean validFieldName(String filedName) {
        boolean isValid;
        boolean bl = isValid = CharSequenceUtil.isNotBlank((CharSequence)filedName) && filedName.matches("(([A-Za-z0-9_]{1,10}\\.)?[A-Za-z0-9_]{1,64})") && !PageableConstants.SQL_KEYWORDS.contains(filedName);
        if (!isValid) {
            log.warn("\u5f02\u5e38\u7684\u5206\u9875\u67e5\u8be2\u6392\u5e8f\u5b57\u6bb5\uff1a{}", (Object)filedName);
        }
        return isValid;
    }

    protected void paramValidate(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory, PageParam pageParam) throws Exception {
        if (binderFactory != null) {
            WebDataBinder binder = binderFactory.createBinder(webRequest, (Object)pageParam, "pageParam");
            this.validateIfApplicable(binder, parameter);
            BindingResult bindingResult = binder.getBindingResult();
            long size = pageParam.getSize();
            if (size > (long)this.maxPageSize) {
                bindingResult.addError(new ObjectError("size", "\u5206\u9875\u6761\u6570\u4e0d\u80fd\u5927\u4e8e" + this.maxPageSize));
            }
            if (bindingResult.hasErrors() && this.isBindExceptionRequired(binder, parameter)) {
                throw new MethodArgumentNotValidException(parameter, bindingResult);
            }
            if (mavContainer != null) {
                mavContainer.addAttribute(BindingResult.MODEL_KEY_PREFIX + "pageParam", (Object)bindingResult);
            }
        }
    }

    protected void validateIfApplicable(WebDataBinder binder, MethodParameter parameter) {
        Annotation[] annotations;
        for (Annotation ann : annotations = parameter.getParameterAnnotations()) {
            Object[] validationHints = ValidationAnnotationUtils.determineValidationHints((Annotation)ann);
            if (validationHints == null) continue;
            binder.validate(validationHints);
            break;
        }
    }

    protected boolean isBindExceptionRequired(WebDataBinder binder, MethodParameter parameter) {
        int i = parameter.getParameterIndex();
        Class<?>[] paramTypes = parameter.getExecutable().getParameterTypes();
        boolean hasBindingResult = paramTypes.length > i + 1 && Errors.class.isAssignableFrom(paramTypes[i + 1]);
        return !hasBindingResult;
    }

    public void setPageParameterName(String pageParameterName) {
        this.pageParameterName = pageParameterName;
    }

    public String getPageParameterName() {
        return this.pageParameterName;
    }

    public void setSizeParameterName(String sizeParameterName) {
        this.sizeParameterName = sizeParameterName;
    }

    public String getSizeParameterName() {
        return this.sizeParameterName;
    }

    public void setSortParameterName(String sortParameterName) {
        this.sortParameterName = sortParameterName;
    }

    public String getSortParameterName() {
        return this.sortParameterName;
    }

    public void setMaxPageSize(int maxPageSize) {
        this.maxPageSize = maxPageSize;
    }

    public int getMaxPageSize() {
        return this.maxPageSize;
    }
}

