/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.autoconfigure.web.servlet;

import cn.hutool.core.util.IdUtil;
import com.hccake.ballcat.autoconfigure.web.pageable.DefaultPageParamArgumentResolver;
import com.hccake.ballcat.autoconfigure.web.pageable.PageParamArgumentResolver;
import com.hccake.ballcat.autoconfigure.web.pageable.PageableProperties;
import com.hccake.ballcat.autoconfigure.web.servlet.WebProperties;
import com.hccake.ballcat.autoconfigure.web.trace.TraceIdFilter;
import com.hccake.ballcat.autoconfigure.web.trace.TraceIdGenerator;
import java.util.List;
import javax.servlet.Filter;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@AutoConfiguration
@EnableConfigurationProperties(value={WebProperties.class, PageableProperties.class})
public class WebMvcAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public PageParamArgumentResolver pageParamArgumentResolver(PageableProperties pageableProperties) {
        return new DefaultPageParamArgumentResolver(pageableProperties);
    }

    @Configuration(proxyBeanMethods=false)
    static class CustomWebMvcConfigurer
    implements WebMvcConfigurer {
        private final PageParamArgumentResolver pageParamArgumentResolver;

        public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
            argumentResolvers.add(this.pageParamArgumentResolver);
        }

        public CustomWebMvcConfigurer(PageParamArgumentResolver pageParamArgumentResolver) {
            this.pageParamArgumentResolver = pageParamArgumentResolver;
        }
    }

    @Configuration(proxyBeanMethods=false)
    static class TraceIdConfiguration {
        TraceIdConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={TraceIdGenerator.class})
        public TraceIdGenerator traceIdGenerator() {
            return IdUtil::objectId;
        }

        @Bean
        public FilterRegistrationBean<TraceIdFilter> traceIdFilterRegistrationBean(WebProperties webProperties, TraceIdGenerator traceIdGenerator) {
            String traceIdHeaderName = webProperties.getTraceIdHeaderName();
            TraceIdFilter traceIdFilter = new TraceIdFilter(traceIdHeaderName, traceIdGenerator);
            FilterRegistrationBean registrationBean = new FilterRegistrationBean((Filter)traceIdFilter, new ServletRegistrationBean[0]);
            registrationBean.setOrder(Integer.MIN_VALUE);
            return registrationBean;
        }
    }
}

