/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.autoconfigure.web.trace;

import com.hccake.ballcat.autoconfigure.web.trace.TraceIdGenerator;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.MDC;
import org.springframework.web.filter.OncePerRequestFilter;

public class TraceIdFilter
extends OncePerRequestFilter {
    private final String traceIdHeaderName;
    private final TraceIdGenerator traceIdGenerator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String traceId = request.getHeader(this.traceIdHeaderName);
        if (traceId == null || traceId.isEmpty()) {
            traceId = this.traceIdGenerator.generate();
        }
        MDC.put((String)"traceId", (String)traceId);
        try {
            response.setHeader(this.traceIdHeaderName, traceId);
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            MDC.remove((String)"traceId");
        }
    }

    public TraceIdFilter(String traceIdHeaderName, TraceIdGenerator traceIdGenerator) {
        this.traceIdHeaderName = traceIdHeaderName;
        this.traceIdGenerator = traceIdGenerator;
    }
}

