/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.autoconfigure.web.validation;

import com.hccake.ballcat.common.core.validation.EmptyCurlyToDefaultMessageInterpolator;
import javax.validation.MessageInterpolator;
import javax.validation.Validator;
import javax.validation.executable.ExecutableValidator;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnResource;
import org.springframework.boot.autoconfigure.validation.ValidationAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Role;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;

@AutoConfiguration(before={ValidationAutoConfiguration.class})
@ConditionalOnClass(value={ExecutableValidator.class})
@ConditionalOnResource(resources={"classpath:META-INF/services/javax.validation.spi.ValidationProvider"})
public class BallcatValidationAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={Validator.class, MessageInterpolator.class})
    public EmptyCurlyToDefaultMessageInterpolator messageInterpolator() {
        return new EmptyCurlyToDefaultMessageInterpolator();
    }

    @Bean
    @Role(value=2)
    @ConditionalOnMissingBean(value={Validator.class})
    @ConditionalOnBean(value={MessageInterpolator.class})
    public static LocalValidatorFactoryBean defaultValidator(MessageInterpolator messageInterpolator) {
        LocalValidatorFactoryBean factoryBean = new LocalValidatorFactoryBean();
        factoryBean.setMessageInterpolator(messageInterpolator);
        return factoryBean;
    }
}

