/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.autoconfigure.websocket;

import com.hccake.ballcat.autoconfigure.websocket.SockJsServiceConfigurer;
import com.hccake.ballcat.autoconfigure.websocket.WebSocketProperties;
import com.hccake.ballcat.autoconfigure.websocket.config.LocalMessageDistributorConfig;
import com.hccake.ballcat.autoconfigure.websocket.config.RedisMessageDistributorConfig;
import com.hccake.ballcat.autoconfigure.websocket.config.RocketMqMessageDistributorConfig;
import com.hccake.ballcat.autoconfigure.websocket.config.WebSocketHandlerConfig;
import com.hccake.ballcat.common.websocket.handler.JsonMessageHandler;
import com.hccake.ballcat.common.websocket.handler.PingJsonMessageHandler;
import com.hccake.ballcat.common.websocket.holder.JsonMessageHandlerInitializer;
import com.hccake.ballcat.common.websocket.message.JsonWebSocketMessage;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.config.annotation.EnableWebSocket;
import org.springframework.web.socket.config.annotation.SockJsServiceRegistration;
import org.springframework.web.socket.config.annotation.WebSocketConfigurer;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistration;
import org.springframework.web.socket.server.HandshakeInterceptor;

@AutoConfiguration
@Import(value={WebSocketHandlerConfig.class, LocalMessageDistributorConfig.class, RedisMessageDistributorConfig.class, RocketMqMessageDistributorConfig.class})
@EnableWebSocket
@EnableConfigurationProperties(value={WebSocketProperties.class})
public class WebSocketAutoConfiguration {
    private final WebSocketProperties webSocketProperties;

    @Bean
    @ConditionalOnMissingBean
    public WebSocketConfigurer webSocketConfigurer(List<HandshakeInterceptor> handshakeInterceptor, WebSocketHandler webSocketHandler, @Autowired(required=false) SockJsServiceConfigurer sockJsServiceConfigurer) {
        return registry -> {
            String[] allowedOriginPatterns;
            WebSocketHandlerRegistration registration = registry.addHandler(webSocketHandler, new String[]{this.webSocketProperties.getPath()}).addInterceptors(handshakeInterceptor.toArray(new HandshakeInterceptor[0]));
            String[] allowedOrigins = this.webSocketProperties.getAllowedOrigins();
            if (allowedOrigins != null && allowedOrigins.length > 0) {
                registration.setAllowedOrigins(allowedOrigins);
            }
            if ((allowedOriginPatterns = this.webSocketProperties.getAllowedOriginPatterns()) != null && allowedOriginPatterns.length > 0) {
                registration.setAllowedOriginPatterns(allowedOriginPatterns);
            }
            if (this.webSocketProperties.isWithSockjs()) {
                SockJsServiceRegistration sockJsServiceRegistration = registration.withSockJS();
                if (sockJsServiceConfigurer != null) {
                    sockJsServiceConfigurer.config(sockJsServiceRegistration);
                }
            }
        };
    }

    @Bean
    @ConditionalOnProperty(prefix="ballcat.websocket", name={"heartbeat"}, havingValue="true", matchIfMissing=true)
    public PingJsonMessageHandler pingJsonMessageHandler() {
        return new PingJsonMessageHandler();
    }

    @Bean
    @ConditionalOnMissingBean
    public JsonMessageHandlerInitializer jsonMessageHandlerInitializer(List<JsonMessageHandler<? extends JsonWebSocketMessage>> jsonMessageHandlerList) {
        return new JsonMessageHandlerInitializer(jsonMessageHandlerList);
    }

    public WebSocketAutoConfiguration(WebSocketProperties webSocketProperties) {
        this.webSocketProperties = webSocketProperties;
    }
}

