/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.autoconfigure.websocket;

import com.hccake.ballcat.common.websocket.handler.ConcurrentWebSocketSessionOptions;
import java.util.Arrays;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

@ConfigurationProperties(value="ballcat.websocket")
public class WebSocketProperties {
    public static final String PREFIX = "ballcat.websocket";
    private String path = "/ws";
    private String[] allowedOrigins;
    private String[] allowedOriginPatterns = new String[]{"*"};
    private boolean supportPartialMessages = false;
    private boolean heartbeat = true;
    private boolean mapSession = true;
    private boolean withSockjs = false;
    @NestedConfigurationProperty
    private ConcurrentWebSocketSessionOptions concurrent = new ConcurrentWebSocketSessionOptions();
    private MessageDistributorTypeEnum messageDistributor = MessageDistributorTypeEnum.LOCAL;

    public String getPath() {
        return this.path;
    }

    public String[] getAllowedOrigins() {
        return this.allowedOrigins;
    }

    public String[] getAllowedOriginPatterns() {
        return this.allowedOriginPatterns;
    }

    public boolean isSupportPartialMessages() {
        return this.supportPartialMessages;
    }

    public boolean isHeartbeat() {
        return this.heartbeat;
    }

    public boolean isMapSession() {
        return this.mapSession;
    }

    public boolean isWithSockjs() {
        return this.withSockjs;
    }

    public ConcurrentWebSocketSessionOptions getConcurrent() {
        return this.concurrent;
    }

    public MessageDistributorTypeEnum getMessageDistributor() {
        return this.messageDistributor;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setAllowedOrigins(String[] allowedOrigins) {
        this.allowedOrigins = allowedOrigins;
    }

    public void setAllowedOriginPatterns(String[] allowedOriginPatterns) {
        this.allowedOriginPatterns = allowedOriginPatterns;
    }

    public void setSupportPartialMessages(boolean supportPartialMessages) {
        this.supportPartialMessages = supportPartialMessages;
    }

    public void setHeartbeat(boolean heartbeat) {
        this.heartbeat = heartbeat;
    }

    public void setMapSession(boolean mapSession) {
        this.mapSession = mapSession;
    }

    public void setWithSockjs(boolean withSockjs) {
        this.withSockjs = withSockjs;
    }

    public void setConcurrent(ConcurrentWebSocketSessionOptions concurrent) {
        this.concurrent = concurrent;
    }

    public void setMessageDistributor(MessageDistributorTypeEnum messageDistributor) {
        this.messageDistributor = messageDistributor;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WebSocketProperties)) {
            return false;
        }
        WebSocketProperties other = (WebSocketProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSupportPartialMessages() != other.isSupportPartialMessages()) {
            return false;
        }
        if (this.isHeartbeat() != other.isHeartbeat()) {
            return false;
        }
        if (this.isMapSession() != other.isMapSession()) {
            return false;
        }
        if (this.isWithSockjs() != other.isWithSockjs()) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getAllowedOrigins(), other.getAllowedOrigins())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getAllowedOriginPatterns(), other.getAllowedOriginPatterns())) {
            return false;
        }
        ConcurrentWebSocketSessionOptions this$concurrent = this.getConcurrent();
        ConcurrentWebSocketSessionOptions other$concurrent = other.getConcurrent();
        if (this$concurrent == null ? other$concurrent != null : !this$concurrent.equals(other$concurrent)) {
            return false;
        }
        MessageDistributorTypeEnum this$messageDistributor = this.getMessageDistributor();
        MessageDistributorTypeEnum other$messageDistributor = other.getMessageDistributor();
        return !(this$messageDistributor == null ? other$messageDistributor != null : !((Object)((Object)this$messageDistributor)).equals((Object)other$messageDistributor));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WebSocketProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSupportPartialMessages() ? 79 : 97);
        result = result * 59 + (this.isHeartbeat() ? 79 : 97);
        result = result * 59 + (this.isMapSession() ? 79 : 97);
        result = result * 59 + (this.isWithSockjs() ? 79 : 97);
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getAllowedOrigins());
        result = result * 59 + Arrays.deepHashCode(this.getAllowedOriginPatterns());
        ConcurrentWebSocketSessionOptions $concurrent = this.getConcurrent();
        result = result * 59 + ($concurrent == null ? 43 : $concurrent.hashCode());
        MessageDistributorTypeEnum $messageDistributor = this.getMessageDistributor();
        result = result * 59 + ($messageDistributor == null ? 43 : ((Object)((Object)$messageDistributor)).hashCode());
        return result;
    }

    public String toString() {
        return "WebSocketProperties(path=" + this.getPath() + ", allowedOrigins=" + Arrays.deepToString(this.getAllowedOrigins()) + ", allowedOriginPatterns=" + Arrays.deepToString(this.getAllowedOriginPatterns()) + ", supportPartialMessages=" + this.isSupportPartialMessages() + ", heartbeat=" + this.isHeartbeat() + ", mapSession=" + this.isMapSession() + ", withSockjs=" + this.isWithSockjs() + ", concurrent=" + this.getConcurrent() + ", messageDistributor=" + (Object)((Object)this.getMessageDistributor()) + ")";
    }

    static enum MessageDistributorTypeEnum {
        LOCAL,
        REDIS,
        CUSTOM;

    }
}

