/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.common.xss;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.hccake.ballcat.common.xss.cleaner.JsoupXssCleaner;
import com.hccake.ballcat.common.xss.cleaner.XssCleaner;
import com.hccake.ballcat.common.xss.config.XssProperties;
import com.hccake.ballcat.common.xss.core.XssFilter;
import com.hccake.ballcat.common.xss.core.XssStringJsonDeserializer;
import javax.servlet.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.jackson.Jackson2ObjectMapperBuilderCustomizer;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@EnableConfigurationProperties(value={XssProperties.class})
@ConditionalOnWebApplication
@ConditionalOnProperty(prefix="ballcat.security.xss", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class XssAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(XssAutoConfiguration.class);

    @ConditionalOnMissingBean(value={XssCleaner.class})
    @Bean
    public XssCleaner xssCleaner() {
        return new JsoupXssCleaner();
    }

    @Bean
    public FilterRegistrationBean<XssFilter> xssFilterRegistrationBean(XssProperties xssProperties, XssCleaner xssCleaner) {
        log.debug("XSS \u8fc7\u6ee4\u5df2\u5f00\u542f====");
        XssFilter xssFilter = new XssFilter(xssProperties, xssCleaner);
        FilterRegistrationBean registrationBean = new FilterRegistrationBean((Filter)xssFilter, new ServletRegistrationBean[0]);
        registrationBean.setOrder(-1);
        return registrationBean;
    }

    @Bean
    @ConditionalOnMissingBean(name={"xssJacksonCustomizer"})
    @ConditionalOnBean(value={ObjectMapper.class})
    public Jackson2ObjectMapperBuilderCustomizer xssJacksonCustomizer(XssCleaner xssCleaner) {
        return builder -> builder.deserializerByType(String.class, (JsonDeserializer)new XssStringJsonDeserializer(xssCleaner));
    }
}

