/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.common.xss.cleaner;

import com.hccake.ballcat.common.xss.cleaner.XssCleaner;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.safety.Safelist;

public class JsoupXssCleaner
implements XssCleaner {
    private final Safelist safelist;
    private final String baseUri;

    public JsoupXssCleaner() {
        this.safelist = this.buildSafelist();
        this.baseUri = "";
    }

    public JsoupXssCleaner(Safelist safelist) {
        this.safelist = safelist;
        this.baseUri = "";
    }

    public JsoupXssCleaner(String baseUri) {
        this.safelist = this.buildSafelist();
        this.baseUri = baseUri;
    }

    public JsoupXssCleaner(Safelist safelist, String baseUri) {
        this.safelist = safelist;
        this.baseUri = baseUri;
    }

    protected Safelist buildSafelist() {
        Safelist relaxedSafelist = Safelist.relaxed();
        relaxedSafelist.addAttributes(":all", new String[]{"style", "class"});
        relaxedSafelist.addAttributes("a", new String[]{"target"});
        relaxedSafelist.addProtocols("img", "src", new String[]{"data"});
        return relaxedSafelist;
    }

    @Override
    public String clean(String html) {
        return Jsoup.clean((String)html, (String)this.baseUri, (Safelist)this.safelist, (Document.OutputSettings)new Document.OutputSettings().prettyPrint(false));
    }
}

