/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.common.xss.config;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.http.HttpMethod;

@ConfigurationProperties(prefix="ballcat.security.xss")
public class XssProperties {
    public static final String PREFIX = "ballcat.security.xss";
    private boolean enabled = true;
    private Set<String> includePaths = Collections.singleton("/**");
    private Set<String> excludePaths = new HashSet<String>();
    private final Set<String> includeHttpMethods = new HashSet<String>(Arrays.asList(HttpMethod.POST.name(), HttpMethod.PUT.name(), HttpMethod.PATCH.name()));

    public boolean isEnabled() {
        return this.enabled;
    }

    public Set<String> getIncludePaths() {
        return this.includePaths;
    }

    public Set<String> getExcludePaths() {
        return this.excludePaths;
    }

    public Set<String> getIncludeHttpMethods() {
        return this.includeHttpMethods;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setIncludePaths(Set<String> includePaths) {
        this.includePaths = includePaths;
    }

    public void setExcludePaths(Set<String> excludePaths) {
        this.excludePaths = excludePaths;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XssProperties)) {
            return false;
        }
        XssProperties other = (XssProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        Set<String> this$includePaths = this.getIncludePaths();
        Set<String> other$includePaths = other.getIncludePaths();
        if (this$includePaths == null ? other$includePaths != null : !((Object)this$includePaths).equals(other$includePaths)) {
            return false;
        }
        Set<String> this$excludePaths = this.getExcludePaths();
        Set<String> other$excludePaths = other.getExcludePaths();
        if (this$excludePaths == null ? other$excludePaths != null : !((Object)this$excludePaths).equals(other$excludePaths)) {
            return false;
        }
        Set<String> this$includeHttpMethods = this.getIncludeHttpMethods();
        Set<String> other$includeHttpMethods = other.getIncludeHttpMethods();
        return !(this$includeHttpMethods == null ? other$includeHttpMethods != null : !((Object)this$includeHttpMethods).equals(other$includeHttpMethods));
    }

    protected boolean canEqual(Object other) {
        return other instanceof XssProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        Set<String> $includePaths = this.getIncludePaths();
        result = result * 59 + ($includePaths == null ? 43 : ((Object)$includePaths).hashCode());
        Set<String> $excludePaths = this.getExcludePaths();
        result = result * 59 + ($excludePaths == null ? 43 : ((Object)$excludePaths).hashCode());
        Set<String> $includeHttpMethods = this.getIncludeHttpMethods();
        result = result * 59 + ($includeHttpMethods == null ? 43 : ((Object)$includeHttpMethods).hashCode());
        return result;
    }

    public String toString() {
        return "XssProperties(enabled=" + this.isEnabled() + ", includePaths=" + this.getIncludePaths() + ", excludePaths=" + this.getExcludePaths() + ", includeHttpMethods=" + this.getIncludeHttpMethods() + ")";
    }
}

