/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.common.xss.core;

import cn.hutool.core.text.CharSequenceUtil;
import com.hccake.ballcat.common.xss.cleaner.XssCleaner;
import com.hccake.ballcat.common.xss.config.XssProperties;
import com.hccake.ballcat.common.xss.core.XssRequestWrapper;
import com.hccake.ballcat.common.xss.core.XssStateHolder;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.filter.OncePerRequestFilter;

public class XssFilter
extends OncePerRequestFilter {
    private final XssProperties xssProperties;
    private final XssCleaner xssCleaner;
    private static final AntPathMatcher ANT_PATH_MATCHER = new AntPathMatcher();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        XssStateHolder.open();
        try {
            filterChain.doFilter((ServletRequest)new XssRequestWrapper(request, this.xssCleaner), (ServletResponse)response);
        }
        finally {
            XssStateHolder.remove();
        }
    }

    protected boolean shouldNotFilter(HttpServletRequest request) {
        if (!this.xssProperties.isEnabled()) {
            return true;
        }
        if (!CharSequenceUtil.equalsAnyIgnoreCase((CharSequence)request.getMethod(), (CharSequence[])this.xssProperties.getIncludeHttpMethods().toArray(new String[0]))) {
            return true;
        }
        String requestUri = request.getRequestURI();
        for (String exclude : this.xssProperties.getExcludePaths()) {
            if (!ANT_PATH_MATCHER.match(exclude, requestUri)) continue;
            return true;
        }
        for (String include : this.xssProperties.getIncludePaths()) {
            if (!ANT_PATH_MATCHER.match(include, requestUri)) continue;
            return false;
        }
        return false;
    }

    public XssFilter(XssProperties xssProperties, XssCleaner xssCleaner) {
        this.xssProperties = xssProperties;
        this.xssCleaner = xssCleaner;
    }
}

