/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.common.xss.core;

import com.hccake.ballcat.common.xss.cleaner.XssCleaner;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XssRequestWrapper
extends HttpServletRequestWrapper {
    private static final Logger log = LoggerFactory.getLogger(XssRequestWrapper.class);
    private final XssCleaner xssCleaner;

    public XssRequestWrapper(HttpServletRequest request, XssCleaner xssCleaner) {
        super(request);
        this.xssCleaner = xssCleaner;
    }

    public Map<String, String[]> getParameterMap() {
        LinkedHashMap<String, String[]> map = new LinkedHashMap<String, String[]>();
        Map parameters = super.getParameterMap();
        for (Map.Entry entry : parameters.entrySet()) {
            String[] values = (String[])entry.getValue();
            for (int i = 0; i < values.length; ++i) {
                values[i] = this.xssCleaner.clean(values[i]);
            }
            map.put((String)entry.getKey(), values);
        }
        return map;
    }

    public String[] getParameterValues(String name) {
        String[] values = super.getParameterValues(name);
        if (values == null) {
            return null;
        }
        int count = values.length;
        String[] encodedValues = new String[count];
        for (int i = 0; i < count; ++i) {
            encodedValues[i] = this.xssCleaner.clean(values[i]);
        }
        return encodedValues;
    }

    public String getParameter(String name) {
        String value = super.getParameter(name);
        if (value == null) {
            return null;
        }
        return this.xssCleaner.clean(value);
    }

    public Object getAttribute(String name) {
        Object value = super.getAttribute(name);
        if (value instanceof String) {
            this.xssCleaner.clean((String)value);
        }
        return value;
    }

    public String getHeader(String name) {
        String value = super.getHeader(name);
        if (value == null) {
            return null;
        }
        return this.xssCleaner.clean(value);
    }

    public String getQueryString() {
        String value = super.getQueryString();
        if (value == null) {
            return null;
        }
        return this.xssCleaner.clean(value);
    }
}

